/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "common/commontypes.h"
#include "common/Errors.h"

namespace NS_DM_Client
{
	extern const char* S_eventTypeDescription[];
	extern const char* S_commandSubTypeDescription[];

	enum EventType
	{
		e_sessionStart = 2,
		e_sessionEnd = 4
	};

	enum CommandType
	{
		e_Add = 2,
		e_Delete = 4,
		e_Replace = 8,
		e_Copy = 16,
		e_Get = 32,
		e_Exec = 64,
		e_Atomic = 128,
		e_Sequence = 256
	};

	CommandType operator++(CommandType &command, int);
	EventType operator++(EventType &event, int);

	enum NotificationStatus
	{
 		e_successful,
		e_start,
		e_end,
 		e_failed,
		e_abort,
		e_authentication,
		e_networkFailure,
		e_unknown
	};

	enum Initiator
	{
		e_user,
		e_network,
		e_unknownInitiator
	};

 	class INotification
 	{
 	public:
		class FirmwareUpdate
		{
		public:
			enum EnumFirmwareOperation
			{
				e_Error = 0,
				e_Download,
				e_Update,
				e_DownloadAndUpdate
			};
		};

 		virtual ~INotification() {}

		// status on user's request
		virtual void StartDMSessionStatus(bool isStarted) = 0;
		virtual void CheckFirmwareUpdateStatus(bool isNewFirmware) = 0;
		virtual void ProvisioningUpdate(const StringArray& URIs, CommandType command, EventType eventType, StatusCode resultCode) = 0;

		// status on notification's subscription
		virtual void NotifyDMSessionStatus(EventType eventType, Initiator initiator, NotificationStatus statusCode) = 0;

		virtual void FirmwareInfo(const String &localpath, const String &filename, const int size) = 0;
		virtual void FirmwareUpdateStart(FirmwareUpdate::EnumFirmwareOperation fwo) = 0;
		virtual void FirmwareUpdateFinished(FirmwareUpdate::EnumFirmwareOperation fwo) = 0;
		virtual void StartDRMDCollecting(int duration) = 0;
	};
}
