/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "platform.h"
#include <commontypes.h>
#include <vector>

#ifdef PLATFORM_LINUX
#define DM_ENGINE_API
#elif defined(PLATFORM_WINDOWS)
#ifdef DM_ENGINE_EXPORTS
#define DM_ENGINE_API __declspec(dllexport)
#else
#define DM_ENGINE_API __declspec(dllimport)
#endif // DM_ENGINE_EXPORTS
#else
#define DM_ENGINE_API 
#endif

namespace NS_DM_Client
{

    class IComponent;
    class ProfileComponentsHolder;

    namespace NS_Daemon
    {

        class DM_ENGINE_API Profile
        {
        public:
            Profile();
            virtual ~Profile();

            virtual void            SetName(const char* name);
            virtual const String&   GetName() const;

            virtual void            SetType(const char* type);
            virtual const String&   GetType() const;

            virtual void            SetDescription(const char* desc);
            virtual const String&   GetDescription() const;

            virtual bool    Enable(bool enable = true);
            virtual bool    IsEnabled() const;

            virtual void    SetComponentsHolder(ProfileComponentsHolder* compHolder);
            virtual ProfileComponentsHolder*    GetComponentsHolder();

        private:
            Profile(const Profile&);
            Profile& operator = (const Profile&);

        public:
            typedef std::vector<IComponent*>    Components;

        private:
            bool    m_Enabled;
            String  m_Name;
            String  m_Type;
            String  m_Description;

            ProfileComponentsHolder*    m_compHolder;

            Components    m_AllComps;

        };
    }


}

