/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "serverexchange/Connection.h"

namespace NS_DM_Client
{
	class ProfileComponentsHolder;
	
	namespace NS_Communication
	{
		class DRMDConnection : public Connection
		{
		public:
			DRMDConnection(ConnectionInfo &, String &);
			virtual ~DRMDConnection();
			
		protected:
			virtual void finishSession();
			virtual void notifySessionAborted();
			virtual void notifySessionStarted();
			virtual void notifySessionFinished();

		private:
			String m_OEMSharedKey;
			void configureAccount();
		};
	}
}

