/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

namespace NS_DM_Client
{
	namespace NS_Communication
	{

		/// enum FUMOState defines status values of the fw update operation,
		/// that should be stored info the FUMO/State mo node.
		typedef enum {
			FS_NO_PENDING_OPERATIONS       = 10,
			FS_DOWNLOAD_FAILED             = 20,
			FS_DOWNLOAD_PROGRESSING        = 30,
			FS_DOWNLOAD_COMPLETE           = 40,
			FS_READY_TO_UPDATE             = 50,
			FS_UPDATE_PROGRESSING          = 60,
			FS_UPDATE_FAILED_HAVE_DATA     = 70,
			FS_UPDATE_FAILED_NO_DATA       = 80,
			FS_UPDATE_SUCCESSFUL_HAVE_DATA = 90,
			FS_UPDATE_SUCCESSFUL_NO_DATA   = 100
		} FUMOState;

		/// enum FWCmdStatus defines status values that should be send to the server
		/// notifying the status of the Exec command on the FUMO node.
		typedef enum {
			FW_SUCCESSFUL                  = 200,
			FW_USER_CANCELLED              = 401,
			FW_CORRUPTED_PACKAGE           = 402,
			FW_UNDEFINED_ERROR             = 409,
			FW_UPDATE_FAILED               = 410,
			FW_MALFORMED_URL               = 411,
			FW_ALT_DOWNLOAD_SERVER_ERROR   = 500

		} FWCmdStatus;

		typedef enum {
			FWO_UNDEFINED,
			FWO_DOWNLOAD,
			FWO_DOWNLOAD_AND_UPDATE,
			FWO_UPDATE
		} FWOperation;

	}
}