/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <base/util/MemoryKeyValueStore.h>
#include <syncml/core/Results.h>
#include "serverexchange/wrappers/SCommandAdapter.h"


namespace NS_DM_Client
{
	namespace NS_SyncMLCommand
	{
		typedef boost::shared_ptr<class SResponseCommand> SResponseCommandPtr;

		class SResponseCommand : public NS_SyncMLCommand::SCommandAdapter
		{
		public:
			SResponseCommand();
			virtual ~SResponseCommand();

			void SetMsgRef(const char *);
			const char * GetMsgRef() { return m_msgref; };

			void SetCmdRef(const char *);
			const char * GetCmdRef() { return m_cmdref; };

		private:
			char *m_cmdref;
			char *m_msgref;
		};
	}
}
