/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"

namespace NS_DM_Client
{

class ProfileComponentsHolder;

class IMOTreeManagerListener
{
public:
    IMOTreeManagerListener() { }
    virtual ~IMOTreeManagerListener() { }

    virtual bool Init(ProfileComponentsHolder& pch) = 0;
    virtual bool Release() = 0;

    virtual bool ExecuteOnAdd(const URI& uri) = 0;
    virtual bool ExecuteOnDelete(const URI& uri) = 0;
    virtual bool ExecuteOnReplace(const URI& uri) = 0;
    virtual bool ExecuteOnReplaceProperty(const URI& uri, const String& property_name) = 0;
    virtual bool ExecuteOnCopy(const URI& source, const URI& dest) = 0;

private:
    IMOTreeManagerListener(const IMOTreeManagerListener&);
    IMOTreeManagerListener& operator=(const IMOTreeManagerListener&);
};

}
