#include "ClientAdapter/TestClientAdapter.h"
#include "common/commontypes.h"

void HandleGetRequest(const String& requestType, NS_DM_Client::TestClientAdapter& test)
{
    printf("Received request = '%s'\n", requestType.c_str());
    bool res = false;
    if (requestType == "DevInfo" || requestType == "DevDetail" || requestType == "DMAcc" || requestType == "WiMAXSupp" ||
        requestType == "WiMAX")
    {
        res = test.GetManagementObject(requestType.c_str());
    } 
    else if (requestType == "ClientProfiles")
    {
        res = test.GetClientProfiles();
    }
    else if (requestType == "EMSK")
    {
        printf("Request GetEMSK is not supported");
/*      
        void* someStrBuffer = 0;
        size_t size;
        res = clientAdapter->GetEMSK(someStrBuffer, size);
        if (!res)
        {
            std::cout << "Failed to handle request GetEMSK" << std::endl;
            return;
        }
        if (size != 0)
        {
            char* buffer = new char[size + 1];
            memset(buffer, 0, size + 1);
            memcpy(buffer, someStrBuffer, size);
            std::cout << "Response on GetEMSK: \n" << buffer << std::endl;
            delete [] buffer;
            delete [] someStrBuffer;
        }
        else
            std::cout << "Empty EMSK was returned \n" << std::endl;
*/
        return;

    }
    else // assume requestType = uri
    {
        String mgmtTree;
        res = test.GetManagementTree(requestType.c_str());
    }
    if (!res)
    {
        printf("Failed to handle request");
    }
}
//-------------------------------------------------------------------------------------------

void HandleSetRequest(const String& requestType, NS_DM_Client::TestClientAdapter& test)
{
    printf("Received request = %d", requestType);
    bool res = false;
    if (requestType == "DevInfo" || requestType == "DevDetail" || requestType == "DMAcc" || requestType == "WiMAXSupp" ||
        requestType == "WiMAXSupp")
    {
        res = test.SetManagementObject(requestType.c_str());
    }
    else if (requestType == "EMSK")
    {
        std::string someStrBuffer("Some EMSK");
        res = test.SetEMSK(someStrBuffer.c_str());
    }
    else if (requestType == "DeviceID")
    {
        std::string someStrBuffer("Some DeviceID");
        res = test.SetDeviceID(someStrBuffer.c_str());
    }
    else if (requestType == "Manufacturer")
    {
        std::string someStrBuffer("Some device manufacturer");
        res = test.SetManufacturer(someStrBuffer.c_str());
    }
    else if (requestType == "Model")
    {
        std::string someStrBuffer("Some device model");
        res = test.SetModel(someStrBuffer.c_str());
    }
    else if (requestType == "WiMAX_Diagnostics")
    {
        res = test.SetWiMAXDiagnostics();
    }
    else // assume requestType = fileName (where Management Tree is located)
    {
        res = test.Set(requestType.c_str());
    }

    printf("Response: %d", res);
}
//-------------------------------------------------------------------------------------------

void HandleCheckFirmwareRequest(NS_DM_Client::TestClientAdapter& test)
{
    printf("Received CheckFirmware request");
    bool res = test.CheckFirmware();
    printf("Response: %d", res);
}
//-------------------------------------------------------------------------------------------

void HandleProvisionRequest(NS_DM_Client::TestClientAdapter& test)
{
    printf("Received ProvisionRequest request");
    bool res = test.HandleProvision();
    printf("Response: %d", res);
}
//-------------------------------------------------------------------------------------------

void HandleConfirmationRequest(NS_DM_Client::TestClientAdapter& test)
{
    printf("Received ConfirmationRequest request");
    bool res = test.HandleConfirmation();
    printf("Response: %d", res);
}
//-------------------------------------------------------------------------------------------

void HandleStartDMSessionRequest(NS_DM_Client::TestClientAdapter& test, const char *alerttype)
{
    printf("Received startDMSession request");
    bool res = test.StartDMSession(alerttype);
    printf("Response: %d", res);
}
//-------------------------------------------------------------------------------------------

void HandleNetworkEntry(NS_DM_Client::TestClientAdapter& test, int hnspID, const char* operatorName)
{
    printf("Received NetworkEntry request");
    bool res = test.HandleNetworkEntry(hnspID, operatorName);
    printf("Response: %d", res);
}
//-------------------------------------------------------------------------------------------

void HandleSubscribeRequest(NS_DM_Client::TestClientAdapter& test)
{
    printf("Received Subscribe request");
    bool res = test.Subscribe();
    printf("Response: %d", res);
}
//-------------------------------------------------------------------------------------------

void HandleDRMDReadyRequest(NS_DM_Client::TestClientAdapter& test)
{
    printf("Received DRMDReadyRequest request");
    bool res = test.DRMDReadyRequest();
    printf("Response: %d", res);
}
//-------------------------------------------------------------------------------------------

void HandleProfileActivationStatusRequest(NS_DM_Client::TestClientAdapter& test)
{
    printf("Received ProfileActivationStatusRequest request");
    bool isActive;
    bool res = test.GetProfileActivationStatus(isActive);
    printf("Response: %d. ActivationStatus = %d", res, isActive);
}

void HandleStartBootstrapRequest(NS_DM_Client::TestClientAdapter& test)
{
    printf("Received StartBootstrapRequest request");
    bool res = test.StartBootstrap();
    printf("Response: %d", res);
}

//-------------------------------------------------------------------------------------------

int main(int argc, char* argv[])
{
    if (argc < 2)
    {
        printf("Usage: \n" 
            "TestClientAdapter get ./DevInfo (|| ./DevDetails || ./WiMAX || ./WiMAXSupp)\n" 
            "TestClientAdapter get ClientProfiles\n" 
            "TestClientAdapter set ./DevInfo (|| ./DevDetails || ./WiMAX || ./WiMAXSupp)\n" 
            "TestClientAdapter set FileWithTree\n" 
            "TestClientAdapter checkFirmware\n" 
            "TestClientAdapter startDMSession OptionalAlertType\n" 
            "TestClientAdapter drmdready\n"
            "TestClientAdapter provision\n" 
            "TestClientAdapter confirmation\n" 
            "TestClientAdapter subscribe\n"
            "TestClientAdapter profileActivationStatus\n"
            "TestClientAdapter networkentry\n"
            "TestClientAdapter bootstrap\n"
);
        return 0;
    }

    NS_DM_Client::TestClientAdapter test;
    String requestType = argv[1];

    if (requestType == "get")
    {
        String requestSubType = argv[2];
        HandleGetRequest(requestSubType, test);
    }
    else if (requestType == "set")
    {
//      clock_t start = clock();
        String requestSubType = argv[2];
        HandleSetRequest(requestSubType, test);
//      clock_t finish = clock();
//      double duration = (double)(finish - start) / CLOCKS_PER_SEC;
//      std::cout << "PERFOMANCE: SetRequest, requestSubType = " << requestSubType << ", duration (sec) = " << duration << std::endl;
    }
    else if (requestType == "checkFirmware")
    {
        HandleCheckFirmwareRequest(test);
    }
    else if (requestType == "startDMSession")
    {
        const char *alertType = argc > 2 ? argv[2] : NULL;
        HandleStartDMSessionRequest(test, alertType);
    }
    else if (requestType == "provision")
    {
        HandleProvisionRequest(test);
    }
    else if (requestType == "confirmation")
    {
        HandleConfirmationRequest(test);
    }
    else if (requestType == "entry" || requestType == "netentry" || requestType == "networkentry")
    {
        int hnsp = 0;
        if (argc > 2)
        {
            hnsp = atoi(argv[2]);
        }
        const char* operName = (argc > 3) ? argv[3] : "";
        
        HandleNetworkEntry(test, hnsp, operName);
    }
    else if (requestType == "subscribe" || requestType == "sub")
    {
        HandleSubscribeRequest(test);
    }
    else if (requestType == "drmdready")
    {
        HandleDRMDReadyRequest(test);
    }
    else if (requestType == "profileActivationStatus")
    {
        HandleProfileActivationStatusRequest(test);
    }
    else if (requestType == "bootstrap")
    {
        HandleStartBootstrapRequest(test);
    }

    return 0;
}

