#include "ConfirmationImpl.h"
#include "common/Event.h"
#include <android/log.h>

#define printf(...) __android_log_print(ANDROID_LOG_DEBUG, "ConfirmationImpl", __VA_ARGS__);

namespace NS_DM_Client
{
    ConfirmationImpl::ConfirmationImpl(NS_DM_Client::IClientAdapter& clientAdapter, NS_Common::EventEx* event): 
        m_clientAdapter(clientAdapter),	m_event(event)
    {

    }
    //-------------------------------------------------------------------------------------------

    void ConfirmationImpl::ConfirmationRequired(const String& message)
    {
        printf("Received confirmation required. Message = %s", message.c_str());
        m_clientAdapter.SendConfirmationResponse(message, e_Yes);
        printf("Send conformation with \"YES\" response");
        m_event->signal();
    }
    //-------------------------------------------------------------------------------------------
}
