#include "serverexchange/IServerExchangeManager.h"

/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <syncml/core/DevInf.h>
#include <spds/AccessConfig.h>
#include "daemon/IManager.h"
//#include "commands/SCommandAdapter.h"
#include "serverexchange/firmware/FirmwareManager.h"
#include <NotificationListener/SessionInfo.h>


namespace NS_DM_Client
{
	class MockServerExchangeManager : public IServerExchangeManager
	{
	public:
		/// Add message to the queue
		virtual void AddCommand(NS_SyncMLCommand::SCommandPtr ptrCommand, const char *serverid) {};
		virtual void AddCommands(NS_SyncMLCommand::SCommandsArray &commands, const char *serverid) {};

		/// Get the default DM connection; may be NULL
		virtual NS_Communication::IConnection * DefaultConnection() {return 0;};

		virtual void NotifyDiagnosticsReady(String &serverID, String &origID) {};
		virtual void NotifyFWJobStatus(String &serverID, int result, ExecPtr &exec, const char *alertType) {};

		/// Set list of account read from the DMAcc node
		virtual void SetConnectionsInfo(NS_Communication::ConnInfoList &) {};

		virtual void HandleNetworkEntrance(int homeNspID, const char* operatorName, bool startWIB) {};

		/// Post authentification messages into the sending queue
		//virtual void Authenticate() = 0;
		virtual void SetServerPollerInfo(bool pollingSupported, int pollingInterval, int pollingAttempts) {};

		/// Set server id; value is checked while performing commands on MO tree
		/// typically stored in the MO tree under the ./DMAcc/<X>/ServerID path
		virtual void SetCurentServerID(const char *) {};

		/// Set access configs to be used during next authentification on server
		virtual void SetAccessConfig(Funambol::AccessConfig &accessConfig) {};

		/// Set device info, read from the dmtree
		virtual void SetDevInfo(Funambol::DevInf &devInf) {};

		/// Run client initiated session
		virtual void StartClientSession() {};
		virtual void StartClientSession(NS_SyncMLCommand::SAlertCommandPtr ptrAlert) {};
		virtual bool HasAccountFor(String &serverID) {return false;};

		/// request for DM session
		virtual void RequestSessionStart(const NS_NotificationListener::SessionInfo& sessionInfo) {};

		virtual void RequestFWUpdate(bool userInitiated, const char *fumouri, int data) {};
		/// Start downloading FW file from the specified URL.
		virtual void FirmwareDU(const char *URL, ExecPtr &cmd, bool update) {};

		virtual void UpdateFW(ExecPtr cmd) {};

		virtual void StartWIB(HomeNSPID nspID, const char* operatorName = NULL) {};

		virtual void ProcessBootstrapMessage(const char *bsm, uint length) {};


		virtual bool Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch) { return true; };
		virtual bool Start() { return true; };
		virtual bool Stop() { return true; };
		virtual void Release() {};
		virtual NS_Communication::FirmwareManager* GetFirmwareManager() { return NULL; };
	};
}
