/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */
#pragma once

#include "daemon/INotification.h"
#include <vector>
#include <map>
#include "Message.h"
#include "ProvisionHolder.h"
#include <CritSection.h>

namespace NS_DM_Client
{
	class ClientAdapterStub;

	class NotificationStub: public INotification
	{
	public:
		NotificationStub(ClientAdapterStub& clientAdapterStub);
		void Clear();
		void Add(MsgType notifType, size_t msgId);
		void Delete(MsgType notifType);
		void AddProvisioningUpdateType(size_t msgId, const ProvisionInfoRequest& provision);
		void DeleteProvisioningUpdateType();

		virtual void StartDMSessionStatus(bool isStarted);
		virtual void NotifyDMSessionStatus(EventType eventType, Initiator initiator, NotificationStatus statusCode);
		virtual void CheckFirmwareUpdateStatus(bool isNewFirmware);
		virtual void FirmwareInfo(const String& localpath, const String& filename, const int size);
 		virtual void FirmwareUpdateStart(FirmwareUpdate::EnumFirmwareOperation fwo);
 		virtual void FirmwareUpdateFinished(FirmwareUpdate::EnumFirmwareOperation fwo);
		virtual void StartDRMDCollecting(int duration);

		virtual void ProvisioningUpdate(const StringArray& URIs, CommandType command, EventType eventType, StatusCode resultCode);

		void ConfirmationRequired(const String& message);

	private:
		void sendResponse(MsgType msgType, MsgSubType subType, bool removeMsg, const String& data = "");
		static MsgSubType s_mapFirmwareOperation(FirmwareUpdate::EnumFirmwareOperation fwo);

	private:
		typedef std::vector<size_t> Requests;
		typedef std::map<MsgType, Requests> RegisteredRequests;
		RegisteredRequests m_registeredRequests;
		ClientAdapterStub& m_clientAdapterStub;
		ProvisionSubscribersHolder m_provisionHolder; 

		NS_Common::CritSection m_containersSynch; // critical section for synchronized access to m_registeredRequests and m_porvisionHolder

	};
}
