#include "RequestHandlingThread.h"
#include "ClientAdapter/ClientAdapterStub.h"
#include "Message.h"

namespace NS_DM_Client
{
	RequestHandlingThread::RequestHandlingThread(Message* request, ClientAdapterStub* clientAdapterStub): 
		m_request(request), m_clientAdapterStub(clientAdapterStub)
	{
	}
	//-------------------------------------------------------------------------------------------

	void RequestHandlingThread::run()
	{
		if (m_clientAdapterStub)
			m_clientAdapterStub->handleRequest(*m_request);
		delete m_request;
	}
	//-------------------------------------------------------------------------------------------

	void RequestHandlingThread::postprocess()
	{
		delete this;
	}

}
