/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
    class Buffer;
	class IMgmtObject;

	namespace NS_Common
	{
		class CritSection;
	}

	extern const String S_inFifoName;
	extern const String S_outFifoName;
	extern const String S_profileInfoSeperator;

	extern const String S_true;
	extern const String S_false;

	class IFIFOWrapper;
	bool CreateFIFOWrapperEx(IFIFOWrapper*& fifoWrapper, const String& fifoName, bool isForReading, bool isServerSide, bool isBlocked);
	bool ReadMessageFromFIFO(IFIFOWrapper* fifoWrapper, Buffer& buffer,
		NS_Logging::Logger& logger, NS_Common::CritSection& criticalSection);

	IMgmtObject* GetMgmtObject(size_t subType);

}
