/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "PortableThread.h"

#include "common/platform.h"

#ifndef DM_IPCENGINE_API

#ifdef PLATFORM_LINUX
#define DM_IPCENGINE_API
#elif defined(PLATFORM_WINDOWS)
#ifdef DM_IPCENGINE_EXPORTS
#define DM_IPCENGINE_API __declspec(dllexport)
#else
#define DM_IPCENGINE_API __declspec(dllimport)
#endif // DM_IPCENGINE_EXPORTS
#else
#define DM_IPCENGINE_API
#endif

#endif

namespace NS_DM_Client
{

class IPCDaemonEngine;

class DM_IPCENGINE_API IPCDaemonEngineActionThread : public Thread
{
public:
     IPCDaemonEngineActionThread();
     virtual ~IPCDaemonEngineActionThread();

     bool Init(IPCDaemonEngine* engine);

     virtual void run();

private:
    IPCDaemonEngineActionThread& operator=(IPCDaemonEngineActionThread&);
    IPCDaemonEngineActionThread(IPCDaemonEngineActionThread&);

    IPCDaemonEngine* m_engine;
};

}
