#pragma once

#include <Windows.h>
#include <string>

namespace NS_DM_Client
{
	class IPCDaemonEngine;
	class IDaemonEngine;

	class Service
	{
	public:
		Service();

		void Install();
		void Uninstall();
		void Start();
		void Stop();
		void Restart();
		bool Execute(int numArgs, char** args);
		bool Run();
		void Shutdown();
		bool IsRunning();

		static void WINAPI ServiceDispatch( DWORD numArgs, char **args ); // for SCM 
		static void WINAPI ServiceCtrlHandler( DWORD control ); // for SCM 

	private:
		bool openService(SC_HANDLE& service);

	private:
		std::string m_name;
		SERVICE_STATUS_HANDLE m_statusHandle;
		SERVICE_STATUS m_status;

		IPCDaemonEngine* m_ipcEngine;
		IDaemonEngine* m_engine;

		static Service m_handle;
	};
}