/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "DataScrambler.h"

static const size_t s_keySize = 4;
static char key[s_keySize] = { '\xAA', '\xBB', '\xCC', '\xDD' } ;

namespace NS_DM_Client
{
namespace NS_DataStorage
{

//------------------------------------------------------------------------------------------------------

void scrambleData(void* buffer, size_t size)
{
    char* char_buff = reinterpret_cast<char*>(buffer);

    for (size_t i = 0, k = 0; i < size; ++i)
    {
        char_buff[i] ^= key[i];
		k = ++k & 0x3;
    }
}

//------------------------------------------------------------------------------------------------------

void EncryptData(void* buffer, size_t size)
{
#if defined(DATASTORAGE_SCRAMBLE)
    scrambleData(buffer, size);
#endif
}

//------------------------------------------------------------------------------------------------------

void DecryptData(void* buffer, size_t size)
{
#if defined(DATASTORAGE_SCRAMBLE)
    scrambleData(buffer, size);
#endif
}

//------------------------------------------------------------------------------------------------------



//------------------------------------------------------------------------------------------------------

}
}
