/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "DataStorageDefs.h"

#include <string>
#include <dirent.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>

namespace NS_DM_Client
{

namespace NS_DataStorage
{
//------------------------------------------------------------------------------------------------------
char* itoa(int val, int base)
{
    static char buf[32];
    memset(buf, '\0', 32);
    int i = 30;
    for(; val && i ; --i, val /= base)
    {
        buf[i] = "0123456789abcdef"[val % base];
    }
    return &buf[i+1];
}
//------------------------------------------------------------------------------------------------------
void str_replace(String& src, const String& what, const String& with)
{
    if (what != with) {
        String temp;
        String::size_type prev_pos = 0, pos = src.find(what, 0);
        while (String::npos != pos)
        {
            String substr(src.c_str(), pos);
            temp.append(substr.c_str() + prev_pos).append(with);
//            temp += String(src.begin() + prev_pos, src.begin() + pos) + with;
            prev_pos = pos + what.size();
            pos = src.find(what, prev_pos);
        }
        if (!temp.empty())
        {
            src.append(temp).append(src.c_str() + prev_pos);
//            src = temp + String(src.begin() + prev_pos, src.end());
            if (String::npos == with.find(what))
            {
                str_replace(src, what, with);
            }
        }
    }
}
//------------------------------------------------------------------------------------------------------
}
}
