/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "DeviceAdapter/Diagnostics/CollectDiagnosticsCommand.h"

#include "ManagementObjects/WiMAX_Diagnostics.h"
#include "daemon/ProfileComponentsHolder.h"

#include "NotifyDiagnosticsReadyCommand.h"

const char* const c_DiagnosticsLog = "Diagnostics";

namespace NS_DM_Client
{
namespace NS_DM_Diagnostics
{

CollectDiagnosticsCommand::CollectDiagnosticsCommand(ProfileComponentsHolder* prholder, int duration, 
													 const String &serverID, 
													 const String &origID)
    : m_prholder(prholder), m_duration(duration), m_serverID(serverID), m_origID(origID)
{

}

//-------------------------------------------------------------------------------------------

CollectDiagnosticsCommand::~CollectDiagnosticsCommand()
{

}

//-------------------------------------------------------------------------------------------

bool CollectDiagnosticsCommand::Execute()
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> CollectDiagnosticsCommand::Execute");

    if (!m_prholder)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: ProfileComponentsHolder not set");
        return false;
    }

    IMOTreeManager* treeManager = m_prholder->GetMOTreeManager();
    if (!treeManager)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: can't get tree manager");
        return false;
    }

    WiMAX_Diagnostics diagnostics;
    if (diagnostics.Execute())
    {
        if (diagnostics.Serialize(*treeManager))
        {
            IExecutionQueue* execQueue = m_prholder->GetExecutionQueue();
            if (!execQueue)
            {
                LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: can't get execution queue");
                return false;
            }

            NotifyDiagnosticsReadyCommand* notifyCommand = new(std::nothrow) NotifyDiagnosticsReadyCommand(*m_prholder->GetServerExchangeManager(), m_serverID, m_origID);
            if (!notifyCommand)
            {
                LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: failed to create NotifyDiagnosticsReadyCommand");
                return false;
            }

            if (!execQueue->Add(*notifyCommand))
            {
                delete notifyCommand;
                LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: failed to add NotifyDiagnosticsReadyCommand to execution queue");
                return false;
            }

            LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: success");
            return true;
        }
        else
        {
            LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: failed to serialize tree");
            return false;
        }
    }
    else
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: failed to execute diagnostic from device");
        return false;
    }

    LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed");
    return false;
}

//-------------------------------------------------------------------------------------------

}
}
