/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"
#include "Logger.h"
#include "Utils.h"

namespace NS_DM_Client
{
#ifdef _MSC_VER
#pragma warning (disable : 4267 )
#endif
	typedef unsigned char UINT8;
	typedef unsigned short USHORT;

	extern const String S_loggerName;
	class IMOTreeManager;

	//void ToString(String& destination, void* source, int size);
	String BoolToString(bool source);

	const String S_boolFormat("bool");
	const String S_chrFormat("chr");
	const String S_intFormat("int");
	const String S_slash("/");
	const String S_true("true");
	const String S_false("false");

	bool Serialize(const String& path, const String& data, IMOTreeManager& treeManager, const String& format = S_chrFormat);

	bool Deserialize(const String& path, String& data, IMOTreeManager& treeManager);
	bool Deserialize(const String& path, size_t& data, IMOTreeManager& treeManager);
	bool Deserialize(const String& path, int& data, IMOTreeManager& treeManager);
	bool Deserialize(const String& path, bool& data, IMOTreeManager& treeManager);
	bool Deserialize(const String& path, UINT8& data, IMOTreeManager& treeManager);
}
