#include "TestCommon.h"

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include "ManagementObjects/WiMAXSupp.h"
#include "../../treemanager/UTestMOTree/MockDataStorage.h"

namespace fs = boost::filesystem;
using namespace NS_DM_Client;

void FillInWiMAXSupp(WiMAXSupp& wimaxSupp)
{
	NS_DM_Client::Operator oper;

	NS_DM_Client::RootCA rootCA;
	rootCA.m_CertID = "certID";
	oper.m_RootCA.push_back(rootCA);

	oper.m_TO_IP_REF = "ref";

	NS_DM_Client::EAP eap;
	eap.m_SERVER_REALMS.push_back("ServerRealm");

	eap.m_VFY_SERVER_REALM = 1;

	NS_DM_Client::CERT cert;
	cert.m_CERT_TYPE = "CERT_TYPE";
	eap.m_CERT.push_back(cert);
	oper.m_SubscriptionParameters.m_Primary.m_EAP.push_back(eap);

	NS_DM_Client::OtherSubscriptions otherSubs;
	otherSubs.m_EAP.push_back(eap);
	otherSubs.m_Activated = 1;
	otherSubs.m_Name = "Other Subcription name";
	oper.m_SubscriptionParameters.m_OtherSubscriptions.push_back(otherSubs);

	oper.m_NetworkParameters.m_H_NSP.push_back(1);
	oper.m_NetworkParameters.m_H_NSP.push_back(2);

	NS_DM_Client::ChannelPlanEntries channelPlanEntries; 
	channelPlanEntries.m_BW = 10;
	oper.m_NetworkParameters.m_ChannelPlan.m_Entries.push_back(channelPlanEntries);

	String name1("SomeOperator1");
	String name2("SomeOperator2");
	wimaxSupp.m_Operator[name1] = oper;
	wimaxSupp.m_Operator[name2] = oper;
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeWiMAXSuppFromTree)
{
	NS_DM_Client::WiMAXSupp originalWiMAXSupp;
	FillInWiMAXSupp(originalWiMAXSupp);
	BOOST_CHECK(originalWiMAXSupp.Serialize(*S_treeManager));

	NS_DM_Client::WiMAXSupp newWiMAXSupp;

	BOOST_CHECK(newWiMAXSupp.Deserialize(*S_treeManager));
	BOOST_CHECK(newWiMAXSupp.m_Operator.begin()->second.m_RootCA[0].m_CertID == "certID");

	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeWiMAXSuppInTree)
{
	NS_DM_Client::WiMAXSupp wimaxSupp;
	FillInWiMAXSupp(wimaxSupp);

	BOOST_CHECK(wimaxSupp.Serialize(*S_treeManager));

	fs::path path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/WiMAXSupp/Operator/SomeOperator1/SubscriptionParameters/Primary/EAP", fs::native);
	BOOST_CHECK(fs::exists(path));
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeWiMAXSuppInXml)
{
	NS_DM_Client::WiMAXSupp wimaxSupp;
	FillInWiMAXSupp(wimaxSupp);

	String wimaxSuppXml;
	BOOST_CHECK(wimaxSupp.Serialize(wimaxSuppXml));


	std::string expectedWimaxSupp;
	ReadFromFile("SerializeWiMAXSuppInXml.xml", expectedWimaxSupp);

//	std::cout << wimaxSuppXml << std::endl << std::endl;
	//std::cout << expectedWimaxSupp << std::endl << std::endl;
//	BOOST_CHECK(wimaxSuppXml == expectedWimaxSupp);
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeWiMAXSuppFromXml)
{
	std::string WiMAXSuppXml;
	ReadFromFile("SerializeWiMAXSuppInXml.xml", WiMAXSuppXml);

	String data(WiMAXSuppXml.c_str());
	NS_DM_Client::WiMAXSupp wimaxSupp;
 	BOOST_CHECK(wimaxSupp.Deserialize(data));
 
//  	BOOST_CHECK(wimaxSupp.m_Operator["SomeOperator1"].m_RootCA[0].m_CertID == "certID");
//  	BOOST_CHECK(wimaxSupp.m_Operator["SomeOperator1"].m_TO_IP_REF == "ref");
// 	BOOST_CHECK(wimaxSupp.m_Operator["SomeOperator1"].m_SubscriptionParameters.m_Primary.m_EAP[0].m_SERVER_REALMS[0] == "ServerRealm");
// 	BOOST_CHECK(wimaxSupp.m_Operator["SomeOperator1"].m_NetworkParameters.m_ChannelPlan.m_Entries[0].m_BW == 10);
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------
