/*
 * Copyright 2010 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "common/FString.h"

String::String() : Funambol::StringBuffer()
{}

String::String(const char* str, const size_t &len) : Funambol::StringBuffer(str, len)
{}

String::String(const String &str) : Funambol::StringBuffer(str.c_str()) {}

String& String::operator=(const char* str)
{
    StringBuffer::assign(str);
    return *this;
}

String& String::operator=(const String& str)
{
    StringBuffer::assign(str);
    return *this;
}

String& String::operator+=(const char* str)
{
    StringBuffer::append(str);
    return *this;
}

String& String::operator+=(char c)
{
    StringBuffer::append(StringBuffer().sprintf("%c", c));
    return *this;
}

String& String::assign(const char* s, size_t n)
{
    String str(s, n);
    StringBuffer::assign(str);
    return *this;
}

void String::clear()
{
    reset();
}

int String::compare(const char* s) const
{
    return *this == s ? 0 : 1;
}

int String::compare(const String &str) const
{
    const int own_size = length();
    const int o_size   = str.length();
    const int size     = own_size > o_size ? o_size : own_size;
    char diff = 0;
    for (int i=0; i< size; ++i)
        if ( !(diff = (StringBuffer::operator[](i) - str[i])) ) continue;

    if (!diff)
        diff = own_size - o_size;

    return diff;
}

size_t String::find_first_of(const char * str, size_t pos) const
{
    if (!str || !str[0]) return npos;

    size_t mpos = npos;
    for (size_t i=0; i<strlen(str); ++i)
    {
        char ss[2] = {0};
        ss[0] = str[i];
        size_t pp = find(ss, pos);
        if (pp != npos)
        {
            if (npos == mpos)
                mpos = pp;
            else if (pp < mpos) // new max pos
                mpos = pp;
        }
    }

    return mpos;
}


size_t String::find_last_of(const char * str, size_t pos) const
{
    if (!str || !str[0]) return npos;

    size_t mpos = npos;
    for (size_t i=0; i<strlen(str); ++i)
    {
        char ss[2] = {0};
        ss[0] = str[i];
        size_t pp = rfind(ss, pos);
        if (pp != npos)
        {
            if (npos == mpos)
                mpos = pp;
            else if (pp > mpos) // new min pos
                mpos = pp;
        }
    }

    return mpos;
}

void String::resize(size_type len)
{
    reserve(len);
}

size_t String::size() const
{
    return Funambol::StringBuffer::size;
}

String String::substr(size_t pos, size_t len) const
{
    return String(StringBuffer::substr(pos, len));
}

void String::set(size_t pos, char c)
{
    if (pos < length())
        const_cast<char*>(c_str())[pos] = c;

}

bool compare_cs(const String& ls, const String& rs)
{
    return ls.compare(rs) < 0;
}


String operator+(const String& ls, const String& rs)
{
    String str(ls);
    str.append(rs);
    return str;
}
