/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "daemon/ExecutionQueueInitializer.h"

#include "daemon/ProfileComponentsHolder.h"
#include "daemon/Configuration.h"
#include "daemon/components.h"

#include "executionqueue/ExecutionQueue.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "ExecutionQueueInitializer";

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Daemon;
using namespace NS_DM_Client::NS_ExecutionQueue;

ExecutionQueueInitializer::~ExecutionQueueInitializer(void)
{
}

ExecutionQueueInitializer::ExecutionQueueInitializer(ProfileComponentsHolder& pch)
: m_pch(pch)
{

}

bool ExecutionQueueInitializer::DoInit(StringBuffer& xml)
{
GDLDEBUG("Enter");

    StringBuffer tagContent;
    StringBuffer settingsInfo;
    IExecutionQueue* comp = NULL;
    if (Configuration::S_getTagInfo(xml, c_ExecutionQueueTitle, tagContent))
    {
        comp = new(std::nothrow) ExecutionQueue;
        if (comp != (IExecutionQueue*)NULL)
        {
            StringMap params;
            if (!Configuration::S_readSettings(tagContent, params))
            {
                // DEBUG read settings failed
                GDLWARN("read settings failed");
            }

            StringBuffer loggerInstanceName;
            if (Configuration::S_readLoggerInfo(tagContent, loggerInstanceName))
            {
                // DEBUG read logger info failed
                GDLWARN("read logger info failed");
            }

            if (comp->Init(params, loggerInstanceName .c_str(), m_pch))
            {
                m_pch.SetExecutionQueue(comp);
            }
            else
            {
                GDLWARN("failed to Init");
                comp->Release();
                comp = (IExecutionQueue*)NULL;
            }
        }
        else
        {
            GDLERROR("new ExecutionQueue");
            return false;
        }
    }

GDLDEBUG("Leave");

    return comp != NULL;
}
