/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "daemon/Profile.h"
#include "daemon/ProfileComponentsHolder.h"
#include "daemon/ComponentStartStopFunctors.h"

#include "executionqueue/IExecutionQueue.h"
#include "serverexchange/IServerExchangeManager.h"
#include "treemanager/IMOTreeManager.h"
#include "NotificationListener/INotificationListener.h"

#include <algorithm>

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Daemon;


Profile::Profile()
:m_Enabled(false), m_compHolder(NULL)
{

}

Profile::~Profile(void)
{
    if (m_Enabled)
    {
        Enable(false);
    }

    delete m_compHolder;
    m_compHolder = NULL;
}


void    Profile::SetName(const char* name)
{
    m_Name = name;
}


const String&   Profile::GetName() const
{
    return m_Name;
}

void Profile::SetType(const char* type)
{
    m_Type = type;
}

const String& Profile::GetType() const
{
    return m_Type;
}


void    Profile::SetDescription(const char* desc)
{
    m_Description = desc;
}


const String&   Profile::GetDescription() const
{
    return m_Description;
}


bool    Profile::IsEnabled() const
{
    return m_Enabled;
}


bool Profile::Enable(bool enable)
{
    if (enable == m_Enabled)
    {
        return true;
    }

    if (enable)
    {
        Components  compsStarted;
        compsStarted.reserve(m_AllComps.size());
        ComponentStarter starter(compsStarted);
        std::for_each(m_AllComps.begin(), m_AllComps.end(), starter);
        m_Enabled = starter.IsAllStarted();
        if (!m_Enabled)
        {
            ComponentStoper stopper;
            std::for_each(compsStarted.begin(), compsStarted.end(), stopper);
        }
    }
    else
    {
        ComponentStoper stopper;
        std::for_each(m_AllComps.begin(), m_AllComps.end(), stopper);
        m_Enabled = false;
    }

    return (enable == m_Enabled);
}


void    Profile::SetComponentsHolder(ProfileComponentsHolder* compHolder)
{
    if (m_compHolder)
    {
        delete compHolder;
    }
    m_compHolder = compHolder;

    m_AllComps.clear();
    const size_t max_components = 8;
    m_AllComps.reserve(max_components);

    if (m_compHolder->GetExecutionQueue())
    {
        m_AllComps.push_back(m_compHolder->GetExecutionQueue());
    }

    if (m_compHolder->GetMOTreeManager())
    {
        m_AllComps.push_back(m_compHolder->GetMOTreeManager());
    }

    if (m_compHolder->GetServerExchangeManager())
    {
        m_AllComps.push_back(m_compHolder->GetServerExchangeManager());
    }

    if (m_compHolder->GetNotificationListener())
    {
        m_AllComps.push_back(m_compHolder->GetNotificationListener());
    }


}

ProfileComponentsHolder*    Profile::GetComponentsHolder()
{
    return m_compHolder;
}
