/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "common/commontypes.h"
#include "serverexchange/commands/AdjustDurationCommand.h"
#include "daemon/ProfileComponentsHolder.h"
#include "Logger/LoggerMacroses.h"
#include "treemanager/IMOTreeManager.h"
#include "serverexchange/IServerExchangeManager.h"
#include "Utils.h"


using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;

static const char * const c_LogName = "AdjustDurationCommand";

AdjustDurationCommand::AdjustDurationCommand(ProfileComponentsHolder *pHolder, String &uriDiagnosticsDuration) :
	m_pProfileHolder(pHolder), m_uriDiagnosticsDuration(uriDiagnosticsDuration)
{
	
}


AdjustDurationCommand::~AdjustDurationCommand()
{
}


bool AdjustDurationCommand::Execute()
{
	String value;
	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(m_uriDiagnosticsDuration, value, NULL))
	{
		if (value != "0")
			setZeroDuration();
	}
	else
		GDLDEBUG("failed to get value of the '%s' node", m_uriDiagnosticsDuration.c_str());
	
	return true;
}


void AdjustDurationCommand::setZeroDuration()
{
	Funambol::ComplexData complexData("0");
	
	Funambol::Meta meta;
	meta.setFormat("int");
	meta.setType(TEXT_PLAIN_ENCODING);
	
	Funambol::Target target(m_uriDiagnosticsDuration.c_str());
	Funambol::Item item(&target, NULL, &meta, &complexData, false);
	
	
	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->Replace(m_uriDiagnosticsDuration, item, NULL))
	{
		GDLDEBUG("set duration to 0");
	}
	else
		GDLDEBUG("failed to set duration to 0");
}
