/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "commontypes.h"
#include "serverexchange/commands/ClientSessionCommand.h"
#include "serverexchange/wrappers/SCommandFactory.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "ClientSessionCommand";

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;
using namespace NS_DM_Client::NS_SyncMLCommand;


ClientSessionCommand::ClientSessionCommand(IServerExchangeManager &sem, String sessionType) :
    ServerExchangeCommand(sem), m_sessionType(sessionType)
{
}


bool ClientSessionCommand::Execute()
{
GDLDEBUG("Enter");
    if (!m_sessionType.size())
    {
        m_SEM.StartClientSession();
    }
    else
    {
        SAlertCommandPtr ptrAlert = SCommandFactory::CreateAlert(AC_CLIENT_INITIATED_MGMT, NULL, m_sessionType.c_str(), 0);
        if(ptrAlert.get() == NULL)
        {
            GDLWARN("ptrAlert is NULL");
        }
        m_SEM.StartClientSession(ptrAlert);
    }
GDLDEBUG("Leave");

    return true;
}
