/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <base/util/utils.h>
#include "serverexchange/wrappers/SCommandAdapter.h"
#include <Logger/LoggerMacroses.h>

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_SyncMLCommand;


SCommandAdapter::SCommandAdapter() :
    m_cmdid(NULL), m_msgid(NULL),
    /*m_commandID(0),*/ m_status(New), m_msgLength(0)
{
}


SCommandAdapter::SCommandAdapter(const char *msgid, AbstractCommandPtr origcmd) :
    m_ptrOriginatedCommand(origcmd),
    m_cmdid(NULL),
    m_msgid(NULL), /*m_commandID(0),*/ m_status(New), m_msgLength(0)
{
}


SCommandAdapter::~SCommandAdapter()
{
    SAFE_DELETE_ARR(m_cmdid);
    SAFE_DELETE_ARR(m_msgid);
}


Funambol::StringBuffer * SCommandAdapter::ToString()
{
    return new Funambol::StringBuffer();
}


void SCommandAdapter::SetCmdID(const char *cmdid)
{
    SAFE_DELETE_ARR(m_cmdid);
    m_cmdid = Funambol::stringdup(cmdid);
}


void SCommandAdapter::SetMessageID(const char *msgid)
{
    SAFE_DELETE_ARR(m_msgid);
    m_msgid = Funambol::stringdup(msgid);
}


void SCommandAdapter::Prepare()
{
    if (!m_ptrItemizedCommand.get())
        createItemizedCommand();
}

