/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <syncml/core/Alert.h>
#include <syncml/core/Item.h>
#include <syncml/core/Source.h>

#include "commontypes.h"
#include "daemon/ProfileComponentsHolder.h"
#include "Logger/LoggerMacroses.h"

#include "treemanager/IMOTreeManager.h"
#include "treemanager/AlertResponseCommand.h"
#include "serverexchange/IServerExchangeManager.h"
#include "serverexchange/wrappers/SCommandFactory.h"

////#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log
////#define LOG_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

using namespace NS_DM_Client;

const char* const c_LogName = "AlertResponseCommand";

AlertResponseCommand::AlertResponseCommand
    (ProfileComponentsHolder* prholder, AlertPtr& cmd, StatusCode getCommandStatus, const String& msgID, std::vector<String> &results, const char *serverid)
    : MOTreeResponseCommand(*prholder->GetServerExchangeManager(), (ItemizedCommandPtr&)cmd, getCommandStatus, msgID, serverid), m_AlertCommand(cmd), m_results(results)
{
    if(cmd.get() == NULL)
    {
        GDLWARN("cmd is NULL");
    }
}


AlertResponseCommand::~AlertResponseCommand()
{
}


bool AlertResponseCommand::Execute()
{
    GDLINFO("FUNCTION STARTED");

    bool res = m_AlertCommand.get() != 0;
    if (res)
    {
        res = performOperation();
    }
    else
    {
        GDLERROR("component holder or command instanse not valid");
    }
    GDLINFO("FUNCTION END. Res: %d", res);
    return res;
}


bool AlertResponseCommand::performOperation()
{
GDLDEBUG("ENTER");

    bool res = false;
    SStatusCommandPtr ptrStatus =
        NS_SyncMLCommand::SCommandFactory::CreateStatus(m_status, *m_AlertCommand.get());

    if (ptrStatus.get() != NULL)
    {
        if (m_status == e_Ok && !m_results.empty())
        {
            ptrStatus->Prepare();
            Funambol::ItemizedCommand *pCommand = ptrStatus->Internal().get();
            if (pCommand)
            {
                Funambol::ArrayList resultItems;
                for (unsigned int i=0; i<m_results.size(); ++i)
                {
                    Funambol::ComplexData data(m_results[i].c_str());
                    Funambol::Item item;
                    item.setData(&data);
                    resultItems.add(item);
                }
            pCommand->setItems(&resultItems);
            }
            else
            {
                GDLWARN("pCommand is NULL");
            }
        }

        enqueueCommand(ptrStatus);
        res = true;
    }
    else
    {
        GDLERROR("SCommandFactory::CreateStatusMessage failed");
    }

GDLDEBUG("LEAVE");

    return res;
}

