/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <syncml/core/Add.h>
#include <syncml/core/Item.h>
#include <syncml/core/Source.h>

#include "commontypes.h"
#include "Logger/LoggerMacroses.h"
#include "treemanager/IMOTreeManager.h"
#include "treemanager/MOTreeResponseCommand.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/wrappers/SCommandFactory.h"

const char* const c_LogName = "MOTreeResponseCommand";

using namespace NS_DM_Client;
using namespace NS_SyncMLCommand;


MOTreeResponseCommand::MOTreeResponseCommand(IServerExchangeManager &sem,
											 AbstractCommandPtr cmd,
											 StatusCode cmdStatus,
											 const String& msgID,
											 const char *serverid)
    :
	ServerExchangeCommand(sem),
	m_acommand(cmd), m_status(cmdStatus), m_messageID(msgID), m_serverID(NULL), m_pCommandsSink(NULL)
{
    if(cmd.get() == NULL)
    {
        GDLWARN("cmd is NULL");
    }

	if (serverid)
		m_serverID = Funambol::stringdup(serverid);
}


MOTreeResponseCommand::MOTreeResponseCommand(IServerExchangeManager &sem,
											 ItemizedCommandPtr cmd, 
											 StatusCode cmdStatus, 
											 const String& msgID,
											 const char *serverid)
	:
	ServerExchangeCommand(sem),
	m_icommand(cmd), m_status(cmdStatus), m_messageID(msgID), m_serverID(NULL), m_pCommandsSink(NULL)
{
    if(cmd.get() == NULL)
    {
        GDLWARN("cmd is NULL");
    }

	if (serverid)
		m_serverID = Funambol::stringdup(serverid);
}


MOTreeResponseCommand::~MOTreeResponseCommand()
{
	SAFE_DELETE(m_serverID);
}


bool MOTreeResponseCommand::Execute()
{
    bool res = (m_acommand.get() != 0) || (m_icommand.get() != 0);
    if (res)
    {
		res = false;
		res = performOperation();
    }
    else
    {
        GDLERROR("%s", "component holder or command instanse not valid");
    }

    return res;
}


void MOTreeResponseCommand::SetCommandsSink(NS_SyncMLCommand::ICommandsSink &sink)
{
	m_pCommandsSink = &sink;
}


void MOTreeResponseCommand::enqueueCommand(NS_SyncMLCommand::SCommandPtr ptrCommand)
{
    if(ptrCommand.get() == NULL)
    {
        GDLWARN("ptrCommand is NULL");
    }

	if (m_serverID && m_pCommandsSink)
		m_pCommandsSink->AddCommand(ptrCommand, m_serverID);
	else
		GDLERROR("!losing command's response: no serverID or SEM instance is set ['%s','%x']", m_serverID ? m_serverID : "", m_pCommandsSink);
}


bool MOTreeResponseCommand::performOperation()
{
	bool res = false;

	SStatusCommandPtr ptrStatus;
	if (m_acommand)
		ptrStatus = SCommandFactory::CreateStatus(m_status, *m_acommand.get());
	else if (m_icommand)
		ptrStatus = SCommandFactory::CreateStatus(m_status, *m_icommand.get());

	if (ptrStatus.get() != NULL)
	{
		enqueueCommand(ptrStatus);
		res = true;
	}
	else
	{
		GDLERROR("%s", "SCommandFactory::CreateStatusMessage failed");
	}

	return res;
}
