
#include "MOTreeManagerMock.h"

#include "Errors.h"

namespace NS_DM_Client
{

bool MOTreeManagerMock::Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch)
{
    return true;
}

bool MOTreeManagerMock::Start()
{
    return true;
}

bool MOTreeManagerMock::Stop()
{
    return true;
}

void MOTreeManagerMock::Release()
{

}


//------------------------------------------------------------------------------------------------------
StatusCode MOTreeManagerMock::Get(const URI& uri, Funambol::Item& item, const char* serverId)
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::GetValue(const URI& uri, String& value, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::GetPropertyValue(const URI& uri, const String& property_name, String& value, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::GetChildren(const URI& uri, ChildrenPaths& children, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::GetAttributeStructData(const URI& uri, Funambol::ArrayList& items, bool keepData, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::Add(const URI& uri, const Funambol::Item& item, const char* serverId, bool isUpdateRequired)
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::Delete(const URI& uri, const char* serverId)
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::Replace(const URI& uri, const Funambol::Item& item, const char* serverId, bool isUpdateRequired)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::ReplacePropertyValue(const URI& uri, const String& property_name, const String& new_value, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::Copy(const URI& source, const URI& dest, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::ExecPermitted(const URI& path, const char* serverId)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::SetPropertyValue(const URI& uri, const String& property_name, const String& value)
{
    return e_Ok;
}

StatusCode MOTreeManagerMock::StartTransaction()
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::Rollback()
{
    return e_Ok;
}
StatusCode MOTreeManagerMock::Commit()
{
    return e_Ok;
}

//------------------------------------------------------------------------------------------------------
}
