#pragma once

#include "daemon/INotificationCenter.h"

#include "commontypes.h"
#include <vector>

namespace NS_DM_Client
{

class NotificationCenterMock : public INotificationCenter
{
public:

    virtual ~NotificationCenterMock() {}

    virtual bool Subscribe(INotification* notification) { return false; };
    virtual bool Unsubscribe(INotification* notification) { return false; };

    virtual void StartDMSessionStatus(bool started) { };
    virtual void CheckFirmwareUpdateStatus(bool isNewFirmware) { };

    virtual void NotifyDMSessionStatus(EventType eventType, Initiator initiator, NotificationStatus statusCode) {};

    virtual void FirmwareInfo(const String &localpath, const String &filename, const int size) { };
    virtual void FirmwareUpdateStart(FirmwareUpdate::EnumFirmwareOperation fi) { };
    virtual void FirmwareUpdateFinished(FirmwareUpdate::EnumFirmwareOperation fi) { };

    virtual void StartDRMDCollecting(int duration) { };

    struct NotificationsMockData
    {
        NotificationsMockData()
        {

        }

        NotificationsMockData(const char* URI, CommandType command, EventType eventType, StatusCode resultCode)
        {
            m_URI = URI;
            m_command = command;
            m_event = eventType;
            m_resultCode = resultCode;
        }

        String m_URI;
        CommandType m_command;
        EventType m_event;
        StatusCode m_resultCode;
    };

    virtual void ProvisioningUpdate(const StringArray& URIs, CommandType command, EventType eventType, StatusCode resultCode)
    {
        NotificationsMockData mockData("", command, eventType, resultCode);
        for (StringArray::const_iterator ptr = URIs.begin(); ptr != URIs.end(); ++ptr)
        {
            mockData.m_URI = ptr->c_str();
            m_mockData.push_back(mockData);
        }
    }

    void clearMockData()
    {
        m_mockData.clear();
    }


public:

    std::vector<NotificationsMockData> m_mockData;
    typedef std::vector<NotificationsMockData>::iterator MockDataIterator;
};

}
