#define BOOST_TEST_MAIN

#include <iostream>
#include <boost/test/included/unit_test.hpp>
#include "Common.h"
#include "DataStorage/IDataStorage.h"
#include "common/Buffer.h"
#include "commontypes.h"
#include "daemon/ProfileComponentsHolder.h"
#include "daemon/Profile.h"


#include "Mocks/ServerExchangeManagerMock.h"
#include "Mocks/ExecutionQueueMock.h"
#include "Mocks/NotificationCenterMock.h"
#include "../../UTestMOTree/MockDeviceAdapter.h"
#include "../../UTestMOTree/MockDeviceUpdater.h"

#include "treemanager/MOTreeManager.h"

NS_DM_Client::ProfileComponentsHolder* S_ProfileHolder = 0;
NS_DM_Client::IDeviceAdapter* S_DeviceAdapter = 0;
NS_DM_Client::IDeviceUpdater* S_DeviceUpdater = 0;
NS_DM_Client::NS_DataStorage::IDataStorage* S_dataStorage = 0;
NS_DM_Client::INotificationCenter* S_notificationCenter = 0;
NS_DM_Client::IMOTreeManager* S_treeManager = 0;

const char* c_testProfile = "";
const char* const c_testPrivateDataPath = "/tmp/Funambol/DMClient/DataStorage";
const char* c_PrivateDataExt = ".priv";

class InitTreeManager
{
public:
	InitTreeManager()
	{
        fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath());

		S_dataStorage = NS_DM_Client::NS_DataStorage::CreateDataStorage(c_testProfile, c_testPrivateDataPath);
		S_treeManager = new NS_DM_Client::MOTreeManager;
		S_DeviceAdapter = new NS_DM_Client::MockDeviceAdapter();
		S_DeviceUpdater = new NS_DM_Client::MockDeviceUpdater(); // will be deletes in MOTree::Transaction
        S_notificationCenter = new NS_DM_Client::NotificationCenterMock;
        
	NS_DM_Client::NS_Daemon::Profile profile;	


	S_ProfileHolder = new NS_DM_Client::ProfileComponentsHolder(profile);
        S_ProfileHolder->SetDataStorage(S_dataStorage);
		S_ProfileHolder->SetDeviceAdapter(S_DeviceAdapter);
		S_ProfileHolder->SetNotificationCenter(S_notificationCenter);
		S_ProfileHolder->SetMOTreeManager(S_treeManager);

        NS_DM_Client::StringMap settings;
        S_treeManager->Init(settings, "MOTreeManagerUnitTests", *S_ProfileHolder);
		NS_DM_Client::SetDeviceUpdater(*S_treeManager, S_DeviceUpdater);

		std::cout << "Setup" << std::endl;
	}

	~InitTreeManager()
	{
		delete S_ProfileHolder;
		std::cout << "Teardown" << std::endl;
        fs::remove_all(String(NS_DM_Client::NS_DataStorage::GetBasePath() + (String)"/" + c_testProfile).c_str());
        fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath());
	}
};

BOOST_GLOBAL_FIXTURE(InitTreeManager);




BOOST_AUTO_TEST_SUITE(SuiteMOTreeCommand)

BOOST_AUTO_TEST_SUITE_END()
