/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher.graphviz;

import com.google.inject.Inject;
import com.google.inject.grapher.DependencyEdge;
import com.google.inject.grapher.graphviz.ArrowType;
import com.google.inject.grapher.graphviz.CompassPoint;
import com.google.inject.grapher.graphviz.GraphvizEdge;
import com.google.inject.grapher.graphviz.GraphvizRenderer;
import com.google.inject.grapher.graphviz.PortIdFactory;
import com.google.inject.internal.util.;
import com.google.inject.spi.InjectionPoint;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyEdgeFactory
implements DependencyEdge.Factory<String, DependencyEdge<String>> {
    private final GraphvizRenderer renderer;
    private final PortIdFactory portIdFactory;

    @Inject
    public DependencyEdgeFactory(GraphvizRenderer renderer, PortIdFactory portIdFactory) {
        this.renderer = renderer;
        this.portIdFactory = portIdFactory;
    }

    @Override
    public DependencyEdge<String> newDependencyEdge(String fromId, InjectionPoint fromPoint, String toId) {
        GraphvizEdge edge = new GraphvizEdge(fromId, toId);
        if (fromPoint == null) {
            edge.setTailPortId("header");
        } else {
            edge.setTailPortId(this.portIdFactory.getPortId(fromPoint.getMember()));
        }
        this.renderer.addEdge(edge);
        return this.newAdaptor(edge);
    }

    protected GraphvizEdgeAdaptor newAdaptor(GraphvizEdge edge) {
        return new GraphvizEdgeAdaptor(edge);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphvizEdgeAdaptor
    implements DependencyEdge<String> {
        protected final GraphvizEdge edge;

        public GraphvizEdgeAdaptor(GraphvizEdge edge) {
            this.edge = edge;
            this.edge.setArrowHead((List<ArrowType>).ImmutableList.of((Object)((Object)ArrowType.NORMAL)));
            this.edge.setTailCompassPoint(CompassPoint.EAST);
        }
    }
}

