// Copyright (C) 2013 mocchi

#include "OnIrrConvert.h"

void Convert(const irr::core::vector3df &pi, ON_3dPoint &po){
	po.Set(static_cast<double>(pi.X), static_cast<double>(pi.Y), static_cast<double>(pi.Z));
}
void Convert(const irr::core::vector3df &vi, ON_3dVector &vo){
	vo.Set(static_cast<double>(vi.X), static_cast<double>(vi.Y), static_cast<double>(vi.Z));
}
void Convert(const irr::core::aabbox3df &bbi, ON_BoundingBox &bbo){
	Convert(bbi.MinEdge, bbo.m_min);
	Convert(bbi.MaxEdge, bbo.m_max);
}
void Convert(const irr::core::line3df &li, ON_Line &lo){
	Convert(li.start, lo.from);
	Convert(li.end, lo.to);
}