require 'digest'
require 'ethon'

module OSDN; module CLI; module Command
  class FrsUpload < Base
    @@_show_progress = false
    def self._show_progress
      @@_show_progress
    end
    def self._show_progress=(v)
      need_reset = (!!@@_show_progress != !!v)
      @@_show_progress = v
      need_reset and _reset_all_typhoeus_pool
    end

    def self._reset_all_typhoeus_pool
      first_easyid = nil
      while true
        e = Typhoeus::Pool.get
        Typhoeus::Pool.release(e)
        e.__id__ == first_easyid and break
        first_easyid ||= e.__id__
      end
    end
  end
end; end; end

module Ethon
  class Easy
    module Callbacks
      alias_method :set_callbacks_orig, :set_callbacks
      def set_callbacks
        set_callbacks_orig
        if OSDN::CLI::Command::FrsUpload._show_progress
          Curl.set_option(:noprogress, false, handle)
        else
          Curl.set_option(:noprogress, true, handle)
        end
      end
    end
  end
end

module OSDN; module CLI; module Command
  class FrsUpload < Base
    def help
      puts "#{$0} frs_upload [opts] [target_dir]"
      puts "Options:"
      puts "  -n --dry-run               Do noting (use with global -v to inspect)"
      puts "  -p --project=<project>     Target project (numeric id or name)"
      #puts "     --package=<project>     Target package (numeric id)"
      #puts "     --release=<project>     Target release (numeric id)"
      puts "  -v --visibility=<public|private|hidden>"
      puts "                             Default visibility for newly created items"
    end

    def run
      update_token
      opts = GetoptLong.new(
        [ '--dry-run', '-n', GetoptLong::NO_ARGUMENT ],
        [ '--project', '-p', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--release', '-r', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--visibility', '-v', GetoptLong::REQUIRED_ARGUMENT ],
      )
      opts.each do |opt, arg|
        case opt
        when '--project'
          arg.empty? or
            @target_proj = arg
        #when '--release'
        #  arg.empty? or
        #    @target_release = arg
        #when '--package'
        #  arg.empty? or
        #    @target_package = arg
        when '--visibility'
          unless %w(public private hidden).member?(arg)
            logger.fatal "Invalid visibility status: #{arg}"
            exit
          end
          @visibility = arg
        when '--dry-run'
          @dry_run = true
        end
      end

      @target_dir = Pathname.new(ARGV.shift || '.')
      proj_info = api.get_project target_proj # check project existance

      Pathname.glob(@target_dir+'*').each do |pdir|
        unless load_variables(pdir).package_id
          logger.info "Createing new package '#{pdir.basename}'"
          if @dry_run
            pinfo = Hashie::Mash.new id: '(dry-run)', name: pdir.basename, url: '(dry-run)'
          else
            pinfo = api.create_package target_proj, pdir.basename, visibility: @visibility
            update_variables pdir, package_id: pinfo.id
          end
          $stdout.puts "New package '#{pinfo.name}' has been created; #{pinfo.url}"
        end

        Pathname.glob(pdir + '*').each do |rdir|
          vars = load_variables(rdir)
          rinfo = nil
          if vars.release_id
            rinfo = api.get_release target_proj, target_package(rdir), target_release(rdir)
          else vars.release_id
            logger.info "Createing new release '#{rdir.basename}'"
            if @dry_run
              rinfo = Hashie::Mash.new id: '(dry-run)', name: rdir.basename, url: '(dry-run)', files: []
            else
              rinfo = api.create_release target_proj, target_package(rdir), rdir.basename, visibility: @visibility
              update_variables rdir, release_id: rinfo.id
            end
            $stdout.puts "New release '#{rinfo.name}' has been created; #{rinfo.url}"
          end
          
          Pathname.glob(rdir + '*').each do |file|
            if file.directory?
              logger.error "Skip direcotry #{file}"
              next
            end

            logger.debug "Calculating digest for #{file}..."
            digests = {
              sha256: hexdigest(Digest::SHA256, file),
              sha1:   hexdigest(Digest::SHA1, file),
              md5:    hexdigest(Digest::MD5, file),
            }
            if remote_f = rinfo.files.find { |f| f.name == file.basename.to_s }
              if digests.find { |type, dig| dig != remote_f.send("digest_#{type}") }
                logger.error "#{file} was changed from remote file! Please delete remote file before uploading new one."
              end
              logger.warn "Skip already uploaded file '#{file}'"
            else
              logger.info "Uploading file #{file} (#{file.size} bytes)"
              if @dry_run
                finfo = Hashie::Mash.new id: '(dry-run)', url: '(dry-run)'
              else
                logger.level <= Logger::INFO and
                  self.class._show_progress = true
                fio = file.open
                logger.info "Starting upload #{file}..."
                finfo = api.create_release_file target_proj, target_package(rdir), target_release(rdir), fio, visibility: @visibility
                fio.close
                self.class._show_progress = false
                if digests.find { |type, dig| dig != finfo.send("digest_#{type}") }
                  logger.error "File digests are mismatch! Upload file #{file} may be broken! Please check."
                else
                  logger.info "Upload completed."
                end
              end
              $stdout.puts "New file '#{file}' has been uploaded; #{finfo.url}"
            end
          end
        end
      end
    end

    def self.description
      "Upload local file tree and create package/release implicitly."
    end

    private
    def target_proj
      @target_proj and return @target_proj
      vars = load_variables(@target_dir)
      vars.project && !vars.project.empty? and
        return vars.project
      logger.fatal "No target project is specified."
      exit
    end

    def target_package(dir)
      @target_package and return @target_package
      vars = load_variables(dir)
      vars.package_id && !vars.package_id.to_s.empty? and
        return vars.package_id
      logger.fatal "No target package is specified."
      exit
    end

    def target_release(dir)
      @target_release and return @target_release
      vars = load_variables(dir)
      vars.release_id && !vars.release_id.to_s.empty? and
        return vars.release_id
      logger.fatal "No target release is specified."
      exit
    end

    def api
      OSDNClient::ProjectApi.new
    end

    def hexdigest(klass, file)
      fio = file.open
      dig = klass.new
      while buf = fio.read(1024*1024) and buf.length > 0
        dig << buf
      end
      fio.close
      dig.hexdigest
    end

  end
end; end; end
