#!/usr/bin/phpunit
<?php
require_once 'PHPUnit/Framework/TestSuite.php';
require_once dirname(__FILE__)."/lib/kses.php";

spl_autoload_extensions('.php');
spl_autoload_register('spl_autoload');
chdir(dirname(__FILE__)."/..");

class AllTests
{
	public static function suite()
	{
		$suite = new PHPUnit_Framework_TestSuite('sfjpWikiAll');
		
		$dir = dirname(__FILE__);
		$dh = opendir($dir);
		while (($file = readdir($dh)) !== false) {
			if (!preg_match('/^(.*Test)\.php$/', $file, $m))
				continue;
			require_once "{$dir}/{$file}";
			$suite->addTestSuite($m[1]);
		}
		closedir($dh);
		return $suite;
	}

	protected function setUp()
	{
		spl_autoload_register();
	}
 
}

