<?php
namespace sfjp\Wiki\Formatter;
class Buffered_DocNode {
	public $name;
	public $data;
	public $parent;
	public $children = array();

	function __construct($name, $data=null) {
		$this->name = $name;
		$this->data = $data;
	}

	function __destruct() {
		$this->destroy();
	}

	public function destroy() {
		if (isset($this->children)) {
			foreach ($this->children as $c) {
				$c->destroy();
			}
		}
		unset($this->parent);
		unset($this->name);
		unset($this->data);
		unset($this->children);
	}

	public function __toString() {
		return '';
	}

	public function getParent() {
		return $this->parent;
	}

	public function getPrev() {
		$prev = null;
		$found = false;
		foreach ($this->parent->children as $c) {
			if ($c === $this) {
				$found = true;
				break;
			}
			$prev = $c;
		}
		return $found ? $prev : null;
	}

	public function getNext() {
		$idx = null;
		$list = $this->parent->children;
		foreach ($list as $i => $c) {
			if ($c === $this) {
				$idx = $i;
				break;
			}
		}
		return (isset($i) && array_key_exists($idx+1, $list)) ? $list[$idx+1] : null;
	}

	public function hasChildren() {
		return !empty($this->children);
	}

	public function addChild($name, $data=null) {
		$myclass = get_called_class();
		$child = new $myclass($name, $data);
		$child->parent = $this;
		$this->children []= $child;
		return $child;
	}
}

class Buffered_Delegator extends Base {
	public $root_node;
	public $cur_node;
	public $formatter;
  
	function __construct() {
		parent::__construct();
		$this->reset();
	}

	function __destruct() {
		if ($this->root_node) $this->root_node->destroy();
		unset($this->root_node);
		unset($this->cur_node);
		unset($this->formatter);
	}

	public function reset() {
		if ($this->root_node) $this->root_node->destroy();
		$this->root_node = new Buffered_DocNode('*ROOT');
		$this->cur_node = $this->root_node;
		if (!$this->formatter) {
			$this->formatter = new HTML();
		}
		$this->formatter->reset();
	}

	public function cleanup() {
		return $this->render();
	}

	public function render() {
		return $this->render_node($this->root_node);
	}

	protected function render_node($node) {
		$fmt = $this->formatter;
		$ret = '';
		if ($node->name === "*ROOT") {
			# nothing
				} elseif ($node->name === "*RAW") {
			$ret .= $fmt->raw_node($node->data);
		} elseif ($node->name === "*TEXT") {
			$ret .= $fmt->text_node($node->data);
		} else {
			$ret .= $fmt->open_element($node->name, $node->data);
		}
		foreach ($node->children as $child) {
			$ret .= $this->render_node($child);
		}
		if (substr($node->name, 0, 1) != "*") {
			$ret .= $fmt->close_element($node->name, $node->data);
		}
		return $ret;
	}

	public function open_element($name, $opt=null) {
		$this->cur_node = $this->cur_node->addChild($name, $opt);
		return $this->cur_node;
	}

	public function close_element($name, $opt=null) {
		// TODO: now all options are ignored.
		$this->cur_node = $this->cur_node->parent;
		return $this->cur_node;
	}

	public function text_node($text) {
		return $this->cur_node->addChild('*TEXT', $text);
	}

	public function raw_node($string) {
		return $this->cur_node->addChild('*RAW', $string);
	}

	public function _dump_tree() {
		return $this->_inspect_node($this->root_node, 0);
	}

	public function _inspect_node($node, $level) {
		$ret = '';
		for ($i = 0; $level*2 > $i; $i++) {
			$ret .= '&nbsp;';
		}
		$ret .= "+ [" . $node->name . "] (" . htmlspecialchars(substr(print_r($node->data, 1), 0, 80)) . ")<br />";
		foreach ($node->children as $c) {
			$ret .= $this->_inspect_node($c, $level+1);
		}
		return $ret;
	}
}