<?php
namespace sfjp\Wiki\Plugin;
use sfjp\Wiki\Exception\Plugin_Error;
class FootNoteProc {
	public $count = 0;
	public $message = '';
	public $formatter;

	public function process() {
		$fmt = $this->formatter;
		$ret = '';
		if ($this->count == 1) {
			$ret .= $fmt->raw_node('<hr><ol id="footnote" class="footnote">');
		}
		$ret .= $fmt->raw_node("<li id=\"_fn_note-{$this->count}\">"
				       . "<a class=\"footnote-revref footnote-counter\" href=\"#_fn_ref-{$this->count}\">*{$this->count}</a>"
				       . "{$this->message}</li>");
		if (FootNote::$counter - 1 == $this->count) {
			$ret .= $fmt->raw_node('</ol>');
		}
		return $ret;
	}
}

class FootNote extends Base {
  static public $counter = 1;
  public $is_vary = false;
  public function process($args) {
    $oneline_trac = new \sfjp\Wiki\Processor\Trac_oneline();
    $oneline_trac->enable_plugin = false;

    $proc = new FootNoteProc();
    $proc->count     = self::$counter++;
    $proc->formatter = $this->getFormatter();
    $proc->message   = $oneline_trac->process($args[0])->getFormattedText();

    $this->processor->addPostProc($proc);

    return $this->getFormatter()->raw_node(
      "<span id=\"_fn_ref-{$proc->count}\" class=\"footnote-ref\">"
      . "<a href=\"#_fn_note-{$proc->count}\">*{$proc->count}</a></span>");
  }
}