#!/usr/bin/env python

import sys

# see http://code.google.com/intl/ja/apis/analytics/docs/gdata/gdataDeveloperGuide.html
import gdata.analytics.client
import gdata.sample_util


APP_NAME = "ganal_test"
url = "http://sourceforge.jp/magazine/10/04/20/1033216"

def get_account_feed(cli):
    account_query = gdata.analytics.client.AccountFeedQuery()
    feed = cli.get_account_feed(account_query)

    print '-------- Important Feed Data --------'
    print 'id             = ' + feed.id.text
    print 'title          = ' + feed.title.text
    print 'totalResults   = ' + feed.total_results.text
    print 'startIndex     = ' + feed.start_index.text
    print 'itemsPerPage   = ' + feed.items_per_page.text

    print '-------- Entries --------'
    num = 0
    for ent in feed.entry:
        print "-- Entry #%d: --" % num
        print 'title       = ' + ent.title.text
        try:
            print 'id          = ' + ent.get_elements("tableId")[0].text
        except IndexError:
            print 'id          = ' 
        print 'updated     = ' + ent.updated.text
        try:
            print 'accountId   = ' + ent.get_property("ga:accountId").value
        except IndexError:
            print 'accountId   = ' 
        try:
            print 'accountName = ' + ent.get_property("ga:accountName").value
        except IndexError:
            print 'accountName = ' 
        num = num + 1

def get_data_feed(cli, url, max_results):
    table_id = "ga:1443341" # sourceforge.jp
    # url = "http://sourceforge.jp/magazine/10/04/20/1033216"
    data_query = gdata.analytics.client.DataFeedQuery({
            'ids': table_id,
            'start-date': '2010-01-01',
            'end-date': '2010-04-20',
            # 'dimensions': 'ga:source,ga:medium',
            'dimensions': 'ga:pagePath,ga:date',
            'metrics': 'ga:pageviews,ga:visits',
            'sort': 'ga:pagePath',
            'filters': "ga:pagePath=@" + url,
            'max-results': max_results})

    feed = cli.GetDataFeed(data_query)
    f = open("last_result", "w")
    f.write(feed.ToString())
    f.close()

    # print feed
    print '-------- PV/Visits results --------'
    for ent in feed.entry:
#        path = ent.title.text.replace("ga:pagePath=", "")
        path = ent.get_object("ga:pagePath").value
        date = ent.get_object("ga:date").value
        pv = ent.get_object("ga:pageviews").value
        visits = ent.get_object("ga:visits").value
        print "\t".join((path,date,pv,visits))


def main():
    try:
        email = sys.argv[1]
        passwd = sys.argv[2]
        url = sys.argv[3]
        max_results = sys.argv[4]
    except IndexError:
        sys.exit("%s email passwd url max-results" % sys.argv[0])

    cli = gdata.analytics.client.AnalyticsClient(source=APP_NAME)

    # login
    try:
        cli.client_login(email, passwd, APP_NAME)
    except gdata.client.BadAuthentication:
        exit('Invalid user credentials given.')
    except gdata.client.Error:
        exit('Login Error')

    # get account informations
    # get_account_feed(cli)

    # get 
    print >> sys.stderr, "send query..."
    get_data_feed(cli, url, max_results)


if __name__ == "__main__":
    main()
