<?php
require_once('PHPUnit.php');
require_once('DB.php');
require_once('PHPUnit_DB.php');
require_once('testdata.php');
require_once('actual.php');

define('DSN', '');

class PHPUnit_DB_Test extends PHPUnit_TestCase {
    function PHPUnit_DB_Test($name)
    {
        $this->PHPUnit_TestCase($name);
    }
    function setUp()
    {
        $this->clearTable('zipcode_tokyo');
        $this->clearTable('zipcode_kanagawa');
        $this->clearTable('zipcode_aichi');
    }
    /**
     * ˥ݡȤ뤳Ȥǧޤ
     */
    function testImportSuccess()
    {
        global $testdata;
        $d = $testdata;
        
        $this->assertEquals(0, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(0, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(0, $this->getCount('zipcode_aichi'));
        
        $tool = new PHPUnit_DB_Tool(DSN);
        $result = $tool->importTables($d);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
    }
    /**
     * ݡȤǼԤˡƤΥݡȤ̵äȤˤʤ뤳Ȥǧޤ
     */
    function testImportFail()
    {
        global $testdata;
        $d = $testdata;
        
        $d['hoge'] = array();
        
        $this->assertEquals(0, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(0, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(0, $this->getCount('zipcode_aichi'));
        
        $tool = new PHPUnit_DB_Tool(DSN);
        $result = $tool->importTables($d);
        
        $this->assertTrue(PEAR::isError($result), $result->toString());
        $this->assertEquals(0, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(0, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(0, $this->getCount('zipcode_aichi'));
    }
    /**
     * ˥ꥢ뤳Ȥǧޤ
     */
    function testClearSuccess()
    {
        global $testdata;
        $d = $testdata;
        
        $tool = new PHPUnit_DB_Tool(DSN);
        $result = $tool->importTables($d);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
        
        $result = $tool->clearTables(array('zipcode_tokyo', 'zipcode_aichi'));
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(0, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(0, $this->getCount('zipcode_aichi'));
    }
    /**
     * ꥢǼԤ硢ƤΥꥢ̵äȤˤʤ뤳Ȥǧޤ
     */
    function testClearFail()
    {
        global $testdata;
        $d = $testdata;
        
        $tool = new PHPUnit_DB_Tool(DSN);
        $result = $tool->importTables($d);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
        
        $result = $tool->clearTables(array('zipcode_tokyo', 'hoge', 'zipcode_aichi'));
        
        $this->assertTrue(PEAR::isError($result), $result->toString());
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
    }
    /**
     * ˥ݡȤ뤳Ȥǧޤ
     */
    function testExportSuccess()
    {
        global $testdata;
        $d = $testdata;
        global $actual;
        
        $tool = new PHPUnit_DB_Tool(DSN);
        $result = $tool->importTables($d);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
        
        $exportData = $tool->exportTables(array('zipcode_tokyo', 'zipcode_kanagawa', 'zipcode_aichi'));
        
        $this->assertEquals($actual, $exportData);
    }
    /**
     * ݡȤǼԤ硢 PEAR_Error ֥Ȥ֤뤳Ȥǧޤ
     */
    function testExportFail()
    {
        global $testdata;
        $d = $testdata;
        
        $tool = new PHPUnit_DB_Tool(DSN);
        $result = $tool->importTables($d);
        
        $this->assertTrue($result, var_export($result, true));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
        
        $exportData = $tool->exportTables(array('zipcode_tokyo', 'hoge', 'zipcode_kanagawa', 'zipcode_aichi'));
        
        $this->assertTrue(PEAR::isError($exportData));
        $this->assertEquals(3299, $this->getCount('zipcode_tokyo'));
        $this->assertEquals(1511, $this->getCount('zipcode_kanagawa'));
        $this->assertEquals(6787, $this->getCount('zipcode_aichi'));
    }
    function getCount($tableName)
    {
        $conn = &DB::connect(DSN);
        if (PEAR::isError($conn)) {
            die($conn->toString());
        }
        $cnt = $conn->getOne("SELECT COUNT(*) FROM $tableName");
        if (PEAR::isError($cnt)) {
            die($cnt->toString());
        }
        $conn->disconnect();
        return $cnt;
    }
    function clearTable($tableName)
    {
        $conn = DB::connect(DSN);
        if (PEAR::isError($conn)) {
            die($conn->toString());
        }
        $result = $conn->query("DELETE FROM $tableName");
        if (PEAR::isError($result)) {
            die($result->toString());
        }
        $conn->disconnect();
    }
}

$suite = &new PHPUnit_TestSuite('PHPUnit_DB_Test');
$result = PHPUnit::run($suite);
echo $result->toString();
?>
