/*
 */
#include "hw.h"
#include "pci.h"
#include "pc.h"

#define DEBUG_PT1

/* lspci -xxx η
Multimedia controller: Xilinx Corporation Device 211a (rev 01)
00: ee 10 1a 21 06 00 00 02 01 00 80 04 00 20 00 00
10: 00 c0 5f fd 00 00 00 00 00 00 00 00 00 00 00 00
20: 00 00 00 00 00 00 00 00 00 00 00 00 11 ef e5 de
30: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
40: 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00
50: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
60: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
70: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
80: ee 10 1a 21 06 00 00 02 01 00 80 04 00 20 00 00
90: 00 c0 5f fd 00 00 00 00 00 00 00 00 00 00 00 00
a0: 00 00 00 00 00 00 00 00 00 00 00 00 11 ef e5 de
b0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
c0: 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00
d0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
e0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
f0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 */

// lspci̤ξ
char	pt3_pci_copy [256] = {
0x72 ,0x11 ,0x15 ,0x4c ,0x07 ,0x01 ,0x10 ,0x00 ,0x01 ,0x00 ,0x80 ,0x04 ,0x40 ,0x00 ,0x00 ,0x00,
0x0c ,0xf0 ,0xff ,0xf7 ,0x00 ,0x00 ,0x00 ,0x00 ,0x0c ,0xe0 ,0xff ,0xf7 ,0x00 ,0x00 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x8d ,0xee ,0x68 ,0x03,
0x00 ,0x00 ,0x00 ,0x00 ,0x50 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x0a ,0x01 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x60 ,0x61 ,0x00 ,0x02 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x05 ,0x78 ,0x80 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x11 ,0x78 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x01 ,0x80 ,0x03 ,0x00 ,0x08 ,0x00 ,0x00 ,0x00,
0x10 ,0x00 ,0x02 ,0x02 ,0x01 ,0x80 ,0x28 ,0x00 ,0x10 ,0x28 ,0x00 ,0x00 ,0x11 ,0xf4 ,0x03 ,0x01,
0x40 ,0x00 ,0x11 ,0x10 ,0x00 ,0x00 ,0x04 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x1e ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x01 ,0x00 ,0x01 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
};
/* PCI PT1 definitions */

/***********************************************************/
static		FILE	*fp = NULL;					// FIFO˽񤤤ǡ
	static	uint32_t	addr_14 = 0x80;
typedef struct PT1State {
    PCIDevice dev;
    char	buf[(1024 * 4)];
	int     mmio_index ;
	int     mmio_index2 ;
	uint32_t	buf_pos ;
	uint32_t	region[3];
}PT1State;

static		int		reg_count = 0 ;				// Scan˽񤤤Ŀ
static		int		reg_pos_count = 0 ;			// FIFO˽񤤤Ŀ

/*
typedef struct PCIPT1State {
    PCIDevice dev;
	PT1State state ;
} PCIPT1State;
 */
/***********************************************************/

enum{
	START,
	ADDR,
	ADDR2,
	DATA,
	END
};

enum{
	I_END,
	I_ADDRESS,
	I_CLOCK_L,
	I_CLOCK_H,
	I_DATA_L,
	I_DATA_H,
	I_RESET,
	I_SLEEP,	// Sleep 1ms
	I_DATA_L_NOP  = 0x8,
	I_DATA_H_NOP  = 0xC,
	I_DATA_H_READ = 0xD,
	I_DATA_H_ACK0 = 0xE,
	I_DATA_H_ACK1 = 0xF,
};

int	BusCheck(uint8_t value)
{
	if(value == I_END){
		printf("(I_END)");
		return -1 ;
	}
	if(value == I_ADDRESS){
		printf("(I_ADDRESS)");
		return -2 ;
	}
	if(value == I_CLOCK_L){
		printf("(I_CLOCK_L)");
		return -2 ;
	}
	if(value == I_CLOCK_H){
		printf("(I_CLOCK_H)");
		return -2 ;
	}
	if(value == I_DATA_L){
		printf("(I_DATA_L)");
		return -2 ;
	}
	if(value == I_DATA_H){
		printf("(I_DATA_H)");
		return -2 ;
	}
	if(value == I_RESET){
		printf("(I_RESET)");
		return -2 ;
	}
	if(value == I_SLEEP){
		printf("(I_SLEEP)");
		return -2 ;
	}
	if(value == I_DATA_L_NOP){
		return 0 ;
	}
	if(value == I_DATA_H_NOP){
		return 0x80 ;
	}
	if(value == I_DATA_H_READ){
		printf("(I_DATA_H_READ)");
		return -2 ;
	}
	if(value == I_DATA_H_ACK0){
/*
		printf("(I_DATA_H_ACK0)");
*/
		return -2 ;
	}
	if(value == I_DATA_H_ACK1){
		printf("(I_DATA_H_ACK1)");
		return -2 ;
	}
}


static	void	Dump2(char *buffer, int32_t size)
{
	uint8_t	value ;
	uint8_t	data = 0;
	int		bits = 0 ;
	int		lp ;
	int		rc ;
	#define	MAX_CHAR	8

	printf("Size =%d\n", size);
	for(lp = 0 ; lp < size ; lp++){
		value = (buffer[lp] & 0x0F);
		if((rc = BusCheck(value)) == -1){
			break ;
		}else if(rc >= 0){
			data |= (rc >> bits);
			bits += 1 ;
			if(bits >= MAX_CHAR){
				printf("%02x", data);
				data = 0;
				bits = 0;
			}
		}
		value = ((buffer[lp] >> 4) & 0x0F);
		if((rc = BusCheck(value)) == -1){
			break ;
		}else if(rc >= 0){
			data |= (rc >> bits);
			bits += 1 ;
			if(bits >= MAX_CHAR){
				printf("%02x", data);
				data = 0;
				bits = 0;
			}
		}

	}

	fprintf(stdout, "\n");
}
static void pt3_save(QEMUFile* f,void* opaque)
{
    printf("%s: \n", __FUNCTION__);
}

static int pt3_load(QEMUFile* f,void* opaque,int version_id)
{
    printf("%s: \n", __FUNCTION__);
	return 0;
}

/***********************************************************/
static void PT1pci_mmio_writeb(void *opaque, target_phys_addr_t addr, uint32_t val)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: (%08x)addr=%08lx value=%lx\n", __FUNCTION__, s->region[0], addr, val);
}

static void PT1pci_mmio_writew(void *opaque, target_phys_addr_t addr, uint32_t val)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: (%08x)addr=%08lx value=%lx\n", __FUNCTION__, s->region[0], addr, val);
}

static void PT1pci_mmio_writel(void *opaque, target_phys_addr_t addr, uint32_t val)
{
    PT1State *s = opaque;
	static	int			rc = 0;
	static	int			fifo_cnt = 0;
	uint32_t	*ptr = (uint32_t *)s->buf ;
	char		fname[256];
	uint32_t offset ;

    addr -= s->region[0];

	printf("%s: (%08x)addr=%08lx value=%lx\n", __FUNCTION__, s->region[0], addr, val);
	if(addr == 0x10){
		Dump2(s->buf, s->buf_pos);
		s->buf_pos = 0 ;
	}
}

static uint32_t PT1pci_mmio_readb(void *opaque, target_phys_addr_t addr)
{
    PT1State *s = opaque;
    addr -= s->region[0];
	uint32_t	rc = 0;

    printf("%s: (%08x)addr=%08lx\n", __FUNCTION__, s->region[0], addr);
	if(addr == 0x14){
		rc = 0x80 ;
	}
	return rc;
}

static uint32_t PT1pci_mmio_readw(void *opaque, target_phys_addr_t addr)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: (%08x)addr=%08lx\n", __FUNCTION__, s->region[0], addr);

	return 0 ;
}

static uint32_t PT1pci_mmio_readl(void *opaque, target_phys_addr_t addr)
{
    PT1State *s = opaque;
	uint32_t	*ptr = (uint32_t *)s->buf ;
	uint32_t	rc ;

    addr -= s->region[0];

    printf("%s: (%08x)addr=%08lx\n", __FUNCTION__, s->region[0], addr);
	if(addr == 0){
		rc = 0x03040404 ;
	}else if(addr == 0x10){
		addr_14 = 0x1;
	}else if(addr == 0x14){
		rc = addr_14 ;
//		addr_14 = 0x80;
	}
	return rc;
}
/***********************************************************/
static CPUWriteMemoryFunc *pt3_pci_mmio_write[] = {
    PT1pci_mmio_writeb,
    PT1pci_mmio_writew,
    PT1pci_mmio_writel
};
static CPUReadMemoryFunc *pt3_pci_mmio_read[] = {
    PT1pci_mmio_readb,
    PT1pci_mmio_readw,
    PT1pci_mmio_readl
};


/***********************************************************/
static void PT1pci_mmio_writeb2(void *opaque, target_phys_addr_t addr, uint8_t val)
{
    PT1State *s = opaque;
    addr -= s->region[0];
//	if(addr != 0x800){
    	printf("%s: (%08x)addr=%08lx value=%lx\n", __FUNCTION__, s->region[0], addr, val);
//	}else{
		memcpy(&s->buf[s->buf_pos], &val, sizeof(uint8_t));
		s->buf_pos += sizeof(uint8_t);
//	}
}

static void PT1pci_mmio_writew2(void *opaque, target_phys_addr_t addr, uint32_t val)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: (%08x)addr=%08lx value=%lx\n", __FUNCTION__, s->region[0], addr, val);
}

static void PT1pci_mmio_writel2(void *opaque, target_phys_addr_t addr, uint32_t val)
{
    PT1State *s = opaque;
	static	int			rc = 0;
	static	int			fifo_cnt = 0;
	uint32_t	*ptr = (uint32_t *)s->buf ;
	char		fname[256];
	uint32_t offset ;

    addr -= s->region[0];

//	if(addr != 0x800){
    	printf("%s: (%08x)addr=%08lx value=%lx\n", __FUNCTION__, s->region[0], addr, val);
//	}else{
		memcpy(&s->buf[s->buf_pos], &val, sizeof(uint32_t));
		s->buf_pos += sizeof(uint32_t);
//	}
}

static uint32_t PT1pci_mmio_readb2(void *opaque, target_phys_addr_t addr)
{
    PT1State *s = opaque;
    addr -= s->region[0];
	uint32_t	rc = 0;

    printf("%s: (%08x)addr=%08lx\n", __FUNCTION__, s->region[0], addr);
	return rc;
}

static uint32_t PT1pci_mmio_readw2(void *opaque, target_phys_addr_t addr)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: (%08x)addr=%08lx\n", __FUNCTION__, s->region[0], addr);

	return 0 ;
}

static uint32_t PT1pci_mmio_readl2(void *opaque, target_phys_addr_t addr)
{
    PT1State *s = opaque;
	uint32_t	*ptr = (uint32_t *)s->buf ;
	uint32_t	rc ;

    addr -= s->region[0];

    printf("%s: (%08x)addr=%08lx\n", __FUNCTION__, s->region[0], addr);
	if(addr == 0){
		rc = 0x03040404 ;
	}else if(addr == 0x10){
		addr_14 = 0x1;
	}else if(addr == 0x14){
		rc = addr_14 ;
//		addr_14 = 0x80;
	}
	return rc;
}
/***********************************************************/
static CPUWriteMemoryFunc *pt3_pci_mmio_write2[] = {
    PT1pci_mmio_writeb2,
    PT1pci_mmio_writew2,
    PT1pci_mmio_writel2
};
static CPUReadMemoryFunc *pt3_pci_mmio_read2[] = {
    PT1pci_mmio_readb2,
    PT1pci_mmio_readw2,
    PT1pci_mmio_readl2
};
/***********************************************************/

static void pt3_map(PCIDevice *pci_dev, int region_num,
                       uint32_t addr, uint32_t size, int type)
{
	PT1State *d = (PT1State *) pci_dev;
    uint8_t *pci_conf;
	int		lp ;

    printf("pt3_map: region_num=%d addr=%x size = %d  type=%d mmio_index(%x)\n",
			region_num, addr, size, type, d->mmio_index);

    pci_conf = d->dev.config;

/*
	// Dump PCI Config
	printf(" Dump PCI Config\n");
	printf("00: ");
	for(lp = 0 ; lp < 64 ; lp++){
		if((!(lp % 16)) && (lp > 0)){
			printf("\n");
			printf("%02x: ", lp);
		}
		printf("%02x ", pci_conf[lp]);
	}
	printf("\n");
*/
	if(region_num == 0) {
		cpu_register_physical_memory(addr, size, d->mmio_index);
//		d->state.region[region_num] = addr;
	}else{
		cpu_register_physical_memory(addr, size, d->mmio_index2);
	}
}

void pci_pt3_init(PCIDevice *pci_dev)
{
    PT1State *d = (PT1State *)pci_dev;
    uint8_t *pci_conf;
	printf("pci_pt3_init: Start\n");

	printf("pci_pt3_init: pci_register_device End\n");
    pci_conf = d->dev.config;

	memcpy(pci_conf, pt3_pci_copy, 256);
	d->buf_pos = 0 ;

	printf("pci_pt3_init: cpu_register_io_memory Start\n");
    d->mmio_index =
		cpu_register_io_memory(pt3_pci_mmio_read, pt3_pci_mmio_write,d);
    d->mmio_index2 =
		cpu_register_io_memory(pt3_pci_mmio_read2, pt3_pci_mmio_write2,d);

	printf("pci_pt3_init: cpu_register_io_memory\n");

    pci_register_bar(&d->dev, 0, 4096,
                           PCI_ADDRESS_SPACE_MEM, pt3_map);
    pci_register_bar(&d->dev, 2, 4096,
                           PCI_ADDRESS_SPACE_MEM, pt3_map);
	printf("pci_pt3_init: pci_register_io_region\n");
    register_savevm("pt3", 0, 3, pt3_save, pt3_load, d);
	printf("pci_pt3_init: End\n");
}
static PCIDeviceInfo pt3_info = {
	.qdev.name = "pt3",
	.qdev.size = sizeof(PT1State),
	.init      = pci_pt3_init,
};

static void pt3_register_devices(void)
{
	printf("pt3_register_devices Start\n");
	pci_qdev_register(&pt3_info);
}

device_init(pt3_register_devices)
