#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#	Copyright © 2014 dyknon
#
#	This file is part of NicoNicoMemories GUI.
#
#	NicoNicoMemories GUI is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.

import tkinter
import tkinter.messagebox
import threading
import nicovideo.access
import nicovideo.comment
import nicovideo.tools
import nicovideo.logger
import locale
import mimetypes
import time
import re

root = tkinter.Tk()
quelock = threading.Lock()
que_list = []
next_queid = 0
convert_thread = None

midfinder = re.compile(r"^\s*(?:(?:(?:(?:(?:http:)?//?)?www.nicovideo.jp)?/)?watch/)?([a-z]{2}[0-9]+)(?:\?.*)?\s*$")
midfinder2 = re.compile(r"^\s*(?:(?:(?:(?:http:)?//?)?www.nicovideo.jp)?/)?watch/((?:[a-z]{2})?[0-9]+)(?:\?.*)?\s*$")

def add_que(request, dl_video):
	global next_queid

	mo1 = midfinder.search(request)
	mo2 = midfinder.search(request)
	videoid = None
	if mo1:
		videoid = mo1.group(1)
	elif mo2:
		videoid = mo2.group(1)

	newque = {}
	if videoid == None:
		newque["videoid"] = request
		newque["stat"] = "iderr"
		newque["title"] = ""
	else:
		newque["videoid"] = videoid
		newque["dl_video"] = dl_video
		m = nicovideo.access.Video(videoid)
		try:
			m.get_standard_info()
		except nicovideo.err.NotFound:
			newque["stat"] = "notfound"
			newque["title"] = ""
		else:
			newque["m"] = m
			newque["stat"] = "wait"
			newque["title"] = m.title

	quelock.acquire()
	newque["id"] = next_queid
	que_list.append(newque)
	next_queid += 1
	quelock.release()

def do_thread():
	while True:
		quelock.acquire()
		for que in que_list:
			if que["stat"] == "wait":
				quelock.release()
				do_convert(que)
				break
		else:
			quelock.release()
		time.sleep(1)

def do_convert(que):
	def display():
		quelock.acquire()
		que["stat"] = stat + " " + prog
		quelock.release()

	m = que["m"]

	fnf = nicovideo.tools.filename_fixer

	stat = "ダウンロードを開始します"
	prog = ""
	display()

	m.get_standard_info()
	filename = m.title + "[" + m.watch_id + "]"
	system_encoding = locale.getpreferredencoding()
	filename = filename.encode(system_encoding, "replace")
	filename = filename.decode(system_encoding, "replace")

	stat = "コメントにアクセスしています"
	display()
	cmfn = fnf(filename + ".xml")
	conn = m.generate_connection_to_coments()
	res = conn.getresponse()
	if res.status == 200:
		filehandle = open(cmfn, mode="wb")
		filesize = int(res.getheader("Content-Length", default=-1))
		stat = "コメントダウンロード中"
		prog = "0%"
		display()
		sizedled = 0
		lastprint = -1
		while True:
			buf = res.read(1024)
			sizedled += len(buf)
			nowtime = int(time.time())
			if lastprint != nowtime:
				lastprint = nowtime
				if filesize >= 0:
					pst = int(sizedled / filesize * 100 + 0.5)
					prog = "{}%".format(pst)
				else:
					prog = "{}byte".format(sizedled)
				display()
			if len(buf) == 0:
				break
			filehandle.write(buf)
	else:
		stat = "コメントのDLに失敗しました。"
		display()
		return

	if que["dl_video"]:
		stat = "動画ファイルにアクセスしています"
		display()
		conn = m.generate_connection_to_video()
		res = conn.getresponse()
		if res.status == 200:
			mimetype = res.getheader("Content-Type", default="unknown")
			filename_ext = mimetypes.guess_all_extensions(mimetype)
			filename_ext.append("." + mimetype[mimetype.find("/")+1:])
			filename_tail = ""
			if m.info["play_video_url"][len(m.info["play_video_url"])-3:] \
					== "low":
				filename_tail += ""
			filename_tail += filename_ext[0]
			filehandle = open(fnf(filename+filename_tail), mode="wb")
			filesize = int(res.getheader("Content-Length", default=-1))
			stat = "動画ファイルダウンロード中"
			prog = "0%".format(filesize)
			display()
			sizedled = 0
			lastprint = -1
			while True:
				buf = res.read(1024)
				sizedled += len(buf)
				nowtime = int(time.time())
				if lastprint != nowtime:
					lastprint = nowtime
					if filesize >= 0:
						pst = int(sizedled / filesize * 100 + 0.5)
						prog = "{}%".format(pst)
					else:
						prog = "{}byte".format(sizedled)
					display()
				if len(buf) == 0:
					break
				filehandle.write(buf)
		else:
			stat = "動画ファイルのDLに失敗しました。"
			display()
			return

	stat = "コメントを字幕化しています"
	display()
	if not "playerinfo" in m.info_downloaded:
		m.get_player_info()
	if "is_wide" in m.info and int(m.info["is_wide"]):
		vs = nicovideo.comment.VirtualScreen("16:9")
	else:
		vs = nicovideo.comment.VirtualScreen("4:3")
	prog = "xml読み込み中"
	display()
	filehandle = open(cmfn, mode="rb")
	x = nicovideo.comment.interpret_xml(filehandle)
	vs.add(x["threads"])
	filehandle = open(fnf(filename + ".ass"), mode="wb")
	prog = "ass化中"
	display()
	filehandle.write(vs.get_ass().encode("UTF-8", "replace"))

	quelock.acquire()
	que["stat"] = "finish"
	quelock.release()

class NamedInputBox(tkinter.Frame):
	def __init__(self, master=None, name="", value="", width=20):
		tkinter.Frame.__init__(self, master)
		self.pack()
		self.value = tkinter.StringVar()
		self.value.set(value)
		self.lab = tkinter.Label(self, text=name)
		self.lab.pack(side="left", fill="both")
		self.ent = tkinter.Entry(self, textvariable=self.value, width=width)
		self.ent.pack(side="left", fill="both")

class PreviewItem(tkinter.Frame):
	def __init__(self, master):
		tkinter.Frame.__init__(self, master)
		self.idlabel = tkinter.Label(self, text="")
		self.messagelabel = tkinter.Label(self, text="")
		self.titlelabel = tkinter.Label(self, text="")
		self.idlabel.grid(column=0, row=0, sticky="w")
		self.messagelabel.grid(column=1, row=0, sticky="e")
		self.titlelabel.grid(column=0, row=1, columnspan=2)
		self.columnconfigure(self.titlelabel, weight=1)

	def update(self, status):
		self.idlabel["text"] = status["id"]
		self.messagelabel["text"] = status["message"]
		self.titlelabel["text"] = status["title"]

	def set_color(self, color):
		self["background"] = color
		self.idlabel["background"] = color
		self.messagelabel["background"] = color
		self.titlelabel["background"] = color

class PreviewArea(tkinter.LabelFrame):
	def __init__(self, master, label):
		tkinter.LabelFrame.__init__(self, master, text=label, pady=2, padx=2)
		self.preview = tkinter.Canvas(self)
		self.scr_y = tkinter.Scrollbar(self)
		self.scr_x = tkinter.Scrollbar(self)
		self.preview["width"] = 500
		self.preview["height"] = 200
		self.preview["bg"] = "white"
		self.preview["xscrollcommand"] = self.scr_x.set
		self.preview["yscrollcommand"] = self.scr_y.set
		self.scr_x["orient"] = "horizontal"
		self.scr_x["command"] = self.preview.xview
		self.scr_y["orient"] = "vertical"
		self.scr_y["command"] = self.preview.yview
		self.preview.grid(row=0, column=0, sticky="we")
		self.scr_x.grid(row=1, column=0, sticky="we")
		self.scr_y.grid(row=0, column=1, sticky="ns")
		self.preview["scrollregion"] = self.preview.bbox("all")
		self.idlist = []

	def update_state(self):
		quelock.acquire()
		for que in que_list:
			status = {"id": que["videoid"]}
			status["title"] = que["title"]
			if que["stat"] == "wait":
				status["type"] = "wait"
				status["message"] = "順番待ち中です。"
			elif que["stat"] == "notfound":
				status["type"] = "error"
				status["message"] = "動画がありません。"
			elif que["stat"] == "iderr":
				status["type"] = "error"
				status["message"] = "動画ID検出失敗"
			elif que["stat"] == "finish":
				status["type"] = "finish"
				status["message"] = "完了。"
			elif que["stat"] == "error":
				status["type"] = "error"
				status["message"] = "何らかの問題が発生しました。"
			else:
				status["type"] = "prog"
				status["message"] = que["stat"]
			for disp in self.idlist:
				if que["id"] == disp["queid"]:
					disp["status"] = status
					break
			else:
				newdisp = {}
				newdisp["queid"] = que["id"]
				newdisp["status"] = status
				newdisp["item"] = PreviewItem(self)
				newdisp["id"] = self.preview.create_window(0, 0,
					window=newdisp["item"],
					anchor="nw",
					width=500,
					height=40
				)
				self.idlist[0:0] = [newdisp]
		quelock.release()
		ktn = 0
		colortable = ["#ddddff", "#ddffdd"]
		colorindex = 0
		for disp in self.idlist:
			disp["item"].update(disp["status"])
			disp["item"].set_color(colortable[colorindex])
			self.preview.coords(disp["id"], (0, ktn))
			ktn = self.preview.bbox(disp["id"])[3]
			colorindex += 1
			if len(colortable) <= colorindex:
				colorindex = 0
			pass
		self.preview["scrollregion"] = self.preview.bbox("all")
		self.after(10, self.update_state)

class NnmGui(tkinter.Frame):
	def __init__(self, master):
		tkinter.Frame.__init__(self, master)
		self.flag_dl_video = tkinter.BooleanVar()
		self.id_box = NamedInputBox(self, "動画ID:", "", 80)
		self.id_box.bind_all("<Key-Return>", self.do_conv)
		self.id_box.pack(side="top", fill="both")
		self.go_frame = tkinter.Frame(self)
		self.go_frame.pack(side="top", fill="both")
		self.do_button = tkinter.Button(self.go_frame)
		self.do_button["text"] = "GO!"
		self.do_button["command"] = self.do_conv
		self.do_button.pack(side="left", fill="both")
		self.videodl_check = tkinter.Checkbutton(self.go_frame)
		self.videodl_check["text"] = "動画をDLする"
		self.videodl_check["variable"] = self.flag_dl_video
		self.videodl_check.pack(side="left", fill="both")
		self.preview_area = PreviewArea(self, "一覧")
		self.preview_area.pack(side="top")
		self.preview_area.update_state()
	
	def do_conv(self, event=None):
		videoid = self.id_box.value.get()
		dl_video = self.flag_dl_video.get()
		self.subthread = threading.Thread(	target=add_que,
											args=(videoid, dl_video))
		self.subthread.daemon = True
		self.subthread.start()
	
	def fin_conv(self):
		self.do_button["text"] = "GO!"

app = NnmGui(root)
app.pack()
root.title("NicoNicoMemories GUI")
do_thread_obj = threading.Thread(target=do_thread)
do_thread_obj.daemon = True
do_thread_obj.start()
app.mainloop()
