/* vim:set ts=4 sts=4 sw=4 noet fenc=utf-8:

   Copyright 2009 senju@users.sourceforge.jp

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package jp.sourceforge.rabbitBTS.controllers;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.rabbitBTS.Sht;
import jp.sourceforge.rabbitBTS.models.Account;
import jp.sourceforge.rabbitBTS.models.BbsPost;
import jp.sourceforge.rabbitBTS.services.AccountService;
import jp.sourceforge.rabbitBTS.services.BbsService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public final class BbsController extends BaseController {
	@Autowired
	private Validator validator;

	@Autowired
	private AccountService accountService;

	@Autowired
	private BbsService bbsService;

	@RequestMapping(method = RequestMethod.GET)
	public void index(ModelMap model, HttpServletRequest req) {
		final BbsPost g = new BbsPost();
		model.addAttribute(g);
		model.addAttribute("posts", this.bbsService.fetchPosts());
	}

	@RequestMapping(method = RequestMethod.POST)
	public String postEdit(BbsPost post, BindingResult result,
			HttpServletRequest req, ModelMap map) {
		if (!this.isCsrfSafe(result)) {
			return null;
		}

		this.validator.validate(post, result);
		if (result.hasErrors()) {
			Sht.log(this).trace("BBS Post Validate fail.");
			return null;
		}

		final Account acc = this.accountService.getCurrentAccount();
		this.bbsService.addNewPost(post, acc);

		// TODO:メッセージ
		return "redirect:index.html";
	}

}
