/* vim:set ts=4 sts=4 sw=4 noet fenc=utf-8:

   Copyright 2009 senju@users.sourceforge.jp

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package jp.sourceforge.rabbitBTS.controllers;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.rabbitBTS.Sht;
import jp.sourceforge.rabbitBTS.forms.MemberSearchForm;
import jp.sourceforge.rabbitBTS.models.Account;
import jp.sourceforge.rabbitBTS.services.AccountService;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * メンバー検索/管理操作用コントローラ
 */
@Controller
public class MembersController extends BaseController implements IController {
	@Autowired
	private AccountService accountService;

	/**
	 * メンバー一覧画面
	 */
	@RequestMapping(method = RequestMethod.GET)
	public void index(MemberSearchForm form, BindingResult result, ModelMap map) {
		// フォームが空の場合
		if (StringUtils.isEmpty(form.getNickName())) {
			final List<Account> accList = this.accountService.fetchAccounts();
			map.addAttribute("accounts", accList);
			return;
		}
		// TODO:他の条件が入った場合修正
		final Account account = this.accountService.getAccountByNickName(form
				.getNickName());
		final List<Account> accList = new ArrayList<Account>(1);
		map.addAttribute("accounts", accList);
		if (account == null) {
			result.reject("account.not.found");
		} else {
			accList.add(account);
		}
	}

	@RequestMapping(method = RequestMethod.GET)
	public void delete(@RequestParam("id") Long accountId, ModelMap map) {
		// TODO: 管理者チェック
		Account account = null;
		if (accountId != null) {
			account = this.accountService.getAccountById(accountId);
		}

		if (account == null) {
			Sht.log(this).warn("存在しないアカウントの削除が試行されました。");
		}

		map.addAttribute("accForDel", account);
	}

	@RequestMapping(method = RequestMethod.POST)
	public String delete(Long accountId) {
		if (!isCsrfSafe()) {
			// 再試行の必要なし。メンバー一覧に戻る。
			return "redirect:/members/";
		}
		// TODO: 管理者チェック
		if (accountId != null) {
			final Account accForDel = this.accountService
					.getAccountById(accountId);
			// TODO: 取得できたかチェック
			this.accountService.deleteAccount(accForDel);
			// TODO: ランタイム例外の処理
		}
		return "redirect:/members/";
	}
}
