/* vim:set ts=4 sts=4 sw=4 noet fenc=utf-8:

   Copyright 2009 senju@users.sourceforge.jp

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package jp.sourceforge.rabbitBTS.models;

import java.util.Date;

import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

import org.springmodules.validation.bean.conf.loader.annotation.handler.Email;
import org.springmodules.validation.bean.conf.loader.annotation.handler.Length;
import org.springmodules.validation.bean.conf.loader.annotation.handler.NotBlank;
import org.springmodules.validation.bean.conf.loader.annotation.handler.NotNull;

@PersistenceCapable(identityType = IdentityType.APPLICATION)
public class Account {
	@PrimaryKey
	@Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
	private Long accountId;

	/**
	 * ユーザーのニックネーム。変更可能とする。
	 */
	@Persistent
	@NotBlank
	@NotNull
	@Length(max = 10)
	// TODO: 短い
	private String nickName;

	/**
	 * ユーザーのemail。googleアカウント使用時は変更不可とする。
	 */
	@Persistent
	@Email
	@NotBlank
	@NotNull
	private String email;

	/**
	 * 自己紹介
	 */
	@Persistent
	@NotBlank
	@NotNull
	@Length(max = 255)
	// TODO:サロゲートありで満杯までいれると500byte越えるかもね。
	private String bio;

	/**
	 * 最後にシステムにアクセスした日時
	 */
	@Persistent
	@NotNull
	private Date lastAccess;

	/**
	 * 管理者権限を持つかどうか
	 */
	@Persistent
	private boolean admin;

	public Long getAccountId() {
		return this.accountId;
	}

	public Date getLastAccess() {
		return this.lastAccess;
	}

	/**
	 * @return the bio
	 */
	public String getBio() {
		return this.bio;
	}

	public void setLastAccess(Date lastAccess) {
		this.lastAccess = lastAccess;
	}

	/**
	 * @param bio
	 *            the bio to set
	 */
	public void setBio(String bio) {
		this.bio = bio;
	}

	/**
	 * @param accountId
	 *            the accountId to set
	 */
	public void setAccountId(Long accountId) {
		this.accountId = accountId;
	}

	/**
	 * @return the nickName
	 */
	public String getNickName() {
		return this.nickName;
	}

	/**
	 * @return the email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * @param nickName
	 *            the nickName to set
	 */
	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	/**
	 * @param email
	 *            the email to set
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return the admin
	 */
	public boolean isAdmin() {
		return this.admin;
	}

	/**
	 * @param admin
	 *            the admin to set
	 */
	public void setAdmin(boolean isAdmin) {
		this.admin = isAdmin;
	}
}
