/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.api.impl;

import com.sun.xml.bind.api.impl.NameUtil;

public interface NameConverter {
    public static final NameConverter standard = new Standard();
    public static final NameConverter jaxrpcCompatible = new Standard(){

        protected boolean isPunct(char c) {
            return c == '.' || c == '-' || c == ';' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
        }

        protected boolean isLetter(char c) {
            return super.isLetter(c) || c == '_';
        }

        protected int classify(char c0) {
            if (c0 == '_') {
                return 2;
            }
            return super.classify(c0);
        }
    };
    public static final NameConverter smart = new Standard(){

        public String toConstantName(String token) {
            String name = super.toConstantName(token);
            if (NameUtil.isJavaIdentifier(name)) {
                return name;
            }
            return '_' + name;
        }
    };

    public String toClassName(String var1);

    public String toInterfaceName(String var1);

    public String toPropertyName(String var1);

    public String toConstantName(String var1);

    public String toVariableName(String var1);

    public String toPackageName(String var1);

    public static class Standard
    extends NameUtil
    implements NameConverter {
        public String toClassName(String s) {
            return this.toMixedCaseName(this.toWordList(s), true);
        }

        public String toVariableName(String s) {
            return this.toMixedCaseName(this.toWordList(s), false);
        }

        public String toInterfaceName(String token) {
            return this.toClassName(token);
        }

        public String toPropertyName(String s) {
            String prop = this.toClassName(s);
            if (prop.equals("Class")) {
                prop = "Clazz";
            }
            return prop;
        }

        public String toConstantName(String token) {
            return super.toConstantName(token);
        }

        public String toPackageName(String s) {
            return this.toMixedCaseName(this.toWordList(s), false);
        }
    }
}

