package jp.mydns.masahase.abaqus;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import jp.mydns.masahase.AbaqusResult.AbaqusResultType;
import jp.mydns.masahase.InherentStrain.InherentStrainType;
import jp.mydns.masahase.abaqus.weldline.CompositeLine;
import jp.mydns.masahase.abaqus.weldline.CurveLine;
import jp.mydns.masahase.abaqus.weldline.CurveLineMirror;
import jp.mydns.masahase.abaqus.weldline.StraightLine;
import jp.mydns.masahase.abaqus.weldline.StraightLineMirror;
import jp.mydns.masahase.operateXML.AbaqusResultUnMarshaller;
import jp.mydns.masahase.operateXML.InherentStrainUnMarshaller;

public class testPastPE {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length < 4) {
			System.err.println("Need 4 arguments.");
			System.exit(1);
		} else {
			try {
				System.out.println("Initialize...");
				InputStream is17 = new FileInputStream(args[0]);
				InputStream is32 = new FileInputStream(args[1]);
				InputStream ar = new FileInputStream(args[2]);
				ExecutorService exec = Executors.newCachedThreadPool();
				Future<InherentStrainType> fist17 = exec
						.submit(new InherentStrainUnMarshaller(is17));
				Future<InherentStrainType> fist32 = exec
						.submit(new InherentStrainUnMarshaller(is32));
				Future<AbaqusResultType> fart = exec
						.submit(new AbaqusResultUnMarshaller(ar));
				InherentStrainType ist17 = fist17.get();
				InherentStrainType ist32 = fist32.get();
				PastePE ppe = new PastePE();
				System.out.println("Set WeldingLine Information.");
				double[] start, end, ref;
				start = new double[3];
				end = new double[3];
				ref = new double[3];
				start[0] = -52.719877;
				start[1] = 843.53018;
				start[2] = 0.0;
				end[0] = -1.019697778E+03;
				end[1] = 32.13938;
				end[2] = 0.0;
				ref[0] = -52.719877;
				ref[1] = 843.53018;
				ref[2] = -10.0;
				StraightLine wl1 = new StraightLineMirror(ist17, start, end,
						ref);
				ppe.addWeldLine(wl1, 0.0);
				start = new double[3];
				end = new double[3];
				ref = new double[3];
				start[0] = -52.681888;
				start[1] = 1627.281113;
				start[2] = 0.0;
				end[0] = -1953.697778;
				end[1] = 32.13938;
				end[2] = 0.0;
				ref[0] = -52.681888;
				ref[1] = 1627.281113;
				ref[2] = -10.0;
				StraightLine wl2 = new StraightLineMirror(ist17, start, end,
						ref);
				ppe.addWeldLine(wl2, 1.0);
				start = new double[3];
				end = new double[3];
				ref = new double[3];
				start[0] = -44.643685;
				start[1] = 2286.845479;
				start[2] = 0.0;
				end[0] = -2.724037333E+03;
				end[1] = 38.567257;
				end[2] = 0.0;
				ref[0] = -44.643685;
				ref[1] = 2286.845479;
				ref[2] = -10.0;
				StraightLine wl3 = new StraightLineMirror(ist17, start, end,
						ref);
				ppe.addWeldLine(wl3, 2.0);
				start = new double[3];
				end = new double[3];
				ref = new double[3];
				start[0] = -4.193147607E+03;
				start[1] = 105.313542;
				start[2] = 8.5;
				end[0] = -2.584381563E+03;
				end[1] = 682.09084;
				end[2] = 8.5;
				ref[0] = -4.193147607E+03;
				ref[1] = 2.637313542E+03;
				ref[2] = 8.5;
				CurveLine wl4_1 = new CurveLineMirror(ist32, start, end, ref, 0);
				start = new double[3];
				end = new double[3];
				ref = new double[3];
				start[0] = -2.584381563E+03;
				start[1] = 682.09084;
				start[2] = 8.5;
				end[0] = -891.649133;
				end[1] = 2.102270823E+03;
				end[2] = 8.5;
				ref[0] = -2.604950069E+03;
				ref[1] = 706.606764;
				ref[2] = 8.5;
				StraightLine wl4_2 = new StraightLineMirror(ist32, start, end,
						ref);
				start = new double[3];
				end = new double[3];
				ref = new double[3];
				start[0] = -891.649133;
				start[1] = 2.102270823E+03;
				start[2] = 8.5;
				end[0] = -100.044091;
				end[1] = 3.799844091E+03;
				end[2] = 8.5;
				ref[0] = -2.316044091E+03;
				ref[1] = 3.799844091E+03;
				ref[2] = 8.5;
				CurveLine wl4_3 = new CurveLineMirror(ist32, start, end, ref, 0);
				CompositeLine wl4 = new CompositeLine();
				wl4.add(wl4_1);
				wl4.add(wl4_2);
				wl4.add(wl4_3);
				ppe.addWeldLine(wl4, 3.0);
				System.out.println("Set Mesh infomation.");
				AbaqusResultType art = fart.get();
				ppe.setMesh(art);
				System.out.println("Set Output.");
				OutputStream os = new FileOutputStream(args[3]);
				ppe.setOutput(os);
				System.out.println("Pasting...");
				ppe.paste();
				System.out.println("Done.");
				exec.shutdown();
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (ExecutionException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}
}
