package jp.mydns.masahase.abaqus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import jp.mydns.masahase.AbaqusResult.AbaqusResultType;
import jp.mydns.masahase.InherentStrain.InherentStrainType;
import jp.mydns.masahase.abaqus.weldline.StraightLine;

public class testPastePE2 {

	/**
	 * @param args
	 */
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		if (args.length < 3) {
			System.err.println("Need 3 arguments.");
			System.exit(1);
		} else {
			try {
				System.out.println("Initialize...");
				InputStream is17 = new FileInputStream(args[0]);
				JAXBContext jaxbcont = JAXBContext
						.newInstance("jp.mydns.masahase.InherentStrain");
				Unmarshaller um = jaxbcont.createUnmarshaller();
				InherentStrainType ist17 = (InherentStrainType) (um
						.unmarshal(is17));
				PastePE ppe = new PastePE();
				System.out.println("Set WeldingLine Information.");
				double[] start, end, ref;
				start = new double[3];
				end = new double[3];
				ref = new double[3];
				start[0] = 0.0;
				start[1] = 0.0;
				start[2] = 0.0;
				end[0] = 0;
				end[1] = 400.0;
				end[2] = 0.0;
				ref[0] = 0.0;
				ref[1] = 0.0;
				ref[2] = 10.0;
				StraightLine wl1 = new StraightLine(ist17, start, end, ref);
				ppe.addWeldLine(wl1, 0.0);
				System.out.println("Set Mesh infomation.");
				jaxbcont = JAXBContext
						.newInstance("jp.mydns.masahase.AbaqusResult");
				um = jaxbcont.createUnmarshaller();
				AbaqusResultType art = (AbaqusResultType) ((JAXBElement<AbaqusResultType>) um
						.unmarshal(new File(args[1]))).getValue();
				ppe.setMesh(art);
				System.out.println("Set Output.");
				OutputStream os = new FileOutputStream(args[2]);
				ppe.setOutput(os);
				System.out.println("Pasting...");
				ppe.paste();
				System.out.println("Done.");
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (JAXBException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

}
