/**
 * 
 */
package jp.mydns.masahase.abaqus.weldline;

/**
 * 溶接線を表すためのインタフェース
 * @author MASA.H
 * 
 */
public interface IWeldLine {
	/**
	 * 任意座標におけるこの溶接線によるPEを返す
	 * 
	 * @param x
	 *            全体座標におけるx座標
	 * @param y
	 *            全体座標におけるｙ座標
	 * @param z
	 *            全体座標におけるz座標
	 * @return 固有ひずみ6成分 double[6]
	 */
	public double[] getPE(double x, double y, double z);
}
