/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class SedLineBuffer {

	//
	private BufferedReader rd;
	private String now;
	private long lineNumber = 0;

	/**
	 * 
	 * @param reader
	 * @throws IOException
	 */
	public SedLineBuffer(Reader reader) throws IOException {
		rd  = new BufferedReader(reader);
		rline();
	}

	//
	private void rline() throws IOException {
		StringBuffer b;
		String z = rd.readLine();

		if(z == null) {
			now = null;
		} else {
			b = new StringBuffer(z);
			if(b.length() > 0 && b.charAt(b.length() - 1) == '\n') {
				b.deleteCharAt(b.length() - 1);
			}
			now = b.toString();
		}
	}

	/**
	 * 
	 * @return
	 */
	public String readLine() throws IOException {
		String r = now;

		lineNumber++;
		if(r != null)  rline();
		return r;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isLastLine() {
		return now == null;
	}

	/**
	 * 
	 * @return
	 */
	public long getLineNumber() {
		return lineNumber;
	}

}
