/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.cmd;

import java.io.IOException;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;


public class SedTCommand implements SedCommand {

	public SedTCommand(String name) {
		this.label = SedLabel.getInstance(name);
	}

	private SedLabel label;

	@Override
	public String getLongDescription() {
		return "branch if there has been a successful substitution";
	}

	@Override
	public char getName() {
		return 't';
	}

	@Override
	public void process(SedSpace s, SedLineBuffer rd) throws IOException {
		if(s.isSucceed())  s.setNextLabel(label);
	}

	public SedLabel getLabel() {
		return label;
	}

	public int hashCode() {
		return label.hashCode();
	}

	public boolean equals(Object o) {
		if(o instanceof SedTCommand) {
			return label.equals(((SedTCommand)o).label);
		}
		return false;
	}

	public String toString() {
		return "t" + label.getLabelName();
	}

}
