/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.unix.regex;

import net.morilib.unix.charset.IntRange;

public abstract class BasicRegexCharacters {

	public static final BasicRegexCharacters
	DOT = new BasicRegexCharacters() {

		@Override
		public boolean contains(int a, int flags) {
//			return a != '\n';
			return true;
		}

	};

	/**
	 * 
	 * @param a
	 * @return
	 */
	public abstract boolean contains(int a, int flags);

	public static BasicRegexCharacters valueOf(final int ch) {
		return new BasicRegexCharacters() {

			@Override
			public boolean contains(int a, int flags) {
				int d;

				if((flags & BasicPattern.CASE_INSENSITIVE) != 0) {
					d = Character.toLowerCase(ch);
					return d == Character.toLowerCase(a);
				} else {
					return ch == a;
				}
			}

		};
	}

	public static BasicRegexCharacters valueOf(final IntRange r) {
		return new BasicRegexCharacters() {

			@Override
			public boolean contains(int a, int flags) {
				if((flags & BasicPattern.CASE_INSENSITIVE) != 0) {
					return (r.contains(Character.toLowerCase(a)) ||
							r.contains(Character.toUpperCase(a)));
				} else {
					return r.contains(a);
				}
			}

		};
	}

}
